@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.ImagePipelineArgs.builder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineImageScanningConfigurationArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineImageScanningConfigurationArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineImageTestsConfigurationArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineImageTestsConfigurationArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineScheduleArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineScheduleArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineWorkflowArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImagePipelineWorkflowArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Image Builder Image Pipeline.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.imagebuilder.ImagePipeline("example", {
 *     imageRecipeArn: exampleAwsImagebuilderImageRecipe.arn,
 *     infrastructureConfigurationArn: exampleAwsImagebuilderInfrastructureConfiguration.arn,
 *     name: "example",
 *     schedule: {
 *         scheduleExpression: "cron(0 0 * * ? *)",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.imagebuilder.ImagePipeline("example",
 *     image_recipe_arn=example_aws_imagebuilder_image_recipe["arn"],
 *     infrastructure_configuration_arn=example_aws_imagebuilder_infrastructure_configuration["arn"],
 *     name="example",
 *     schedule={
 *         "schedule_expression": "cron(0 0 * * ? *)",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ImageBuilder.ImagePipeline("example", new()
 *     {
 *         ImageRecipeArn = exampleAwsImagebuilderImageRecipe.Arn,
 *         InfrastructureConfigurationArn = exampleAwsImagebuilderInfrastructureConfiguration.Arn,
 *         Name = "example",
 *         Schedule = new Aws.ImageBuilder.Inputs.ImagePipelineScheduleArgs
 *         {
 *             ScheduleExpression = "cron(0 0 * * ? *)",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/imagebuilder"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := imagebuilder.NewImagePipeline(ctx, "example", &imagebuilder.ImagePipelineArgs{
 * 			ImageRecipeArn:                 pulumi.Any(exampleAwsImagebuilderImageRecipe.Arn),
 * 			InfrastructureConfigurationArn: pulumi.Any(exampleAwsImagebuilderInfrastructureConfiguration.Arn),
 * 			Name:                           pulumi.String("example"),
 * 			Schedule: &imagebuilder.ImagePipelineScheduleArgs{
 * 				ScheduleExpression: pulumi.String("cron(0 0 * * ? *)"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.ImagePipeline;
 * import com.pulumi.aws.imagebuilder.ImagePipelineArgs;
 * import com.pulumi.aws.imagebuilder.inputs.ImagePipelineScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ImagePipeline("example", ImagePipelineArgs.builder()
 *             .imageRecipeArn(exampleAwsImagebuilderImageRecipe.arn())
 *             .infrastructureConfigurationArn(exampleAwsImagebuilderInfrastructureConfiguration.arn())
 *             .name("example")
 *             .schedule(ImagePipelineScheduleArgs.builder()
 *                 .scheduleExpression("cron(0 0 * * ? *)")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:imagebuilder:ImagePipeline
 *     properties:
 *       imageRecipeArn: ${exampleAwsImagebuilderImageRecipe.arn}
 *       infrastructureConfigurationArn: ${exampleAwsImagebuilderInfrastructureConfiguration.arn}
 *       name: example
 *       schedule:
 *         scheduleExpression: cron(0 0 * * ? *)
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_image_pipeline` resources using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:imagebuilder/imagePipeline:ImagePipeline example arn:aws:imagebuilder:us-east-1:123456789012:image-pipeline/example
 * ```
 * @property containerRecipeArn Amazon Resource Name (ARN) of the container recipe.
 * @property description Description of the image pipeline.
 * @property distributionConfigurationArn Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
 * @property enhancedImageMetadataEnabled Whether additional information about the image being created is collected. Defaults to `true`.
 * @property executionRole Amazon Resource Name (ARN) of the service-linked role to be used by Image Builder to [execute workflows](https://docs.aws.amazon.com/imagebuilder/latest/userguide/manage-image-workflows.html).
 * @property imageRecipeArn Amazon Resource Name (ARN) of the image recipe.
 * @property imageScanningConfiguration Configuration block with image scanning configuration. Detailed below.
 * @property imageTestsConfiguration Configuration block with image tests configuration. Detailed below.
 * @property infrastructureConfigurationArn Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
 * @property name Name of the image pipeline.
 * The following arguments are optional:
 * @property schedule Configuration block with schedule settings. Detailed below.
 * @property status Status of the image pipeline. Valid values are `DISABLED` and `ENABLED`. Defaults to `ENABLED`.
 * @property tags Key-value map of resource tags for the image pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property workflows Configuration block with the workflow configuration. Detailed below.
 */
public data class ImagePipelineArgs(
    public val containerRecipeArn: Output<String>? = null,
    public val description: Output<String>? = null,
    public val distributionConfigurationArn: Output<String>? = null,
    public val enhancedImageMetadataEnabled: Output<Boolean>? = null,
    public val executionRole: Output<String>? = null,
    public val imageRecipeArn: Output<String>? = null,
    public val imageScanningConfiguration: Output<ImagePipelineImageScanningConfigurationArgs>? =
        null,
    public val imageTestsConfiguration: Output<ImagePipelineImageTestsConfigurationArgs>? = null,
    public val infrastructureConfigurationArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val schedule: Output<ImagePipelineScheduleArgs>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workflows: Output<List<ImagePipelineWorkflowArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.ImagePipelineArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.ImagePipelineArgs =
        com.pulumi.aws.imagebuilder.ImagePipelineArgs.builder()
            .containerRecipeArn(containerRecipeArn?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .distributionConfigurationArn(distributionConfigurationArn?.applyValue({ args0 -> args0 }))
            .enhancedImageMetadataEnabled(enhancedImageMetadataEnabled?.applyValue({ args0 -> args0 }))
            .executionRole(executionRole?.applyValue({ args0 -> args0 }))
            .imageRecipeArn(imageRecipeArn?.applyValue({ args0 -> args0 }))
            .imageScanningConfiguration(
                imageScanningConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .imageTestsConfiguration(
                imageTestsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .infrastructureConfigurationArn(infrastructureConfigurationArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workflows(
                workflows?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ImagePipelineArgs].
 */
@PulumiTagMarker
public class ImagePipelineArgsBuilder internal constructor() {
    private var containerRecipeArn: Output<String>? = null

    private var description: Output<String>? = null

    private var distributionConfigurationArn: Output<String>? = null

    private var enhancedImageMetadataEnabled: Output<Boolean>? = null

    private var executionRole: Output<String>? = null

    private var imageRecipeArn: Output<String>? = null

    private var imageScanningConfiguration: Output<ImagePipelineImageScanningConfigurationArgs>? =
        null

    private var imageTestsConfiguration: Output<ImagePipelineImageTestsConfigurationArgs>? = null

    private var infrastructureConfigurationArn: Output<String>? = null

    private var name: Output<String>? = null

    private var schedule: Output<ImagePipelineScheduleArgs>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workflows: Output<List<ImagePipelineWorkflowArgs>>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the container recipe.
     */
    @JvmName("yndreswrxddqkjxj")
    public suspend fun containerRecipeArn(`value`: Output<String>) {
        this.containerRecipeArn = value
    }

    /**
     * @param value Description of the image pipeline.
     */
    @JvmName("hsynweufhnponjrh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
     */
    @JvmName("ahjhtokxessfttdd")
    public suspend fun distributionConfigurationArn(`value`: Output<String>) {
        this.distributionConfigurationArn = value
    }

    /**
     * @param value Whether additional information about the image being created is collected. Defaults to `true`.
     */
    @JvmName("ucnxmceeeukkbsvp")
    public suspend fun enhancedImageMetadataEnabled(`value`: Output<Boolean>) {
        this.enhancedImageMetadataEnabled = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the service-linked role to be used by Image Builder to [execute workflows](https://docs.aws.amazon.com/imagebuilder/latest/userguide/manage-image-workflows.html).
     */
    @JvmName("uegacwxfownowiac")
    public suspend fun executionRole(`value`: Output<String>) {
        this.executionRole = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the image recipe.
     */
    @JvmName("anqubwbmrhohiasr")
    public suspend fun imageRecipeArn(`value`: Output<String>) {
        this.imageRecipeArn = value
    }

    /**
     * @param value Configuration block with image scanning configuration. Detailed below.
     */
    @JvmName("ltkekxrykndjbvfs")
    public suspend fun imageScanningConfiguration(`value`: Output<ImagePipelineImageScanningConfigurationArgs>) {
        this.imageScanningConfiguration = value
    }

    /**
     * @param value Configuration block with image tests configuration. Detailed below.
     */
    @JvmName("fsvvwtqbixjjqtjn")
    public suspend fun imageTestsConfiguration(`value`: Output<ImagePipelineImageTestsConfigurationArgs>) {
        this.imageTestsConfiguration = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
     */
    @JvmName("ocdrrkmhocmcsmqu")
    public suspend fun infrastructureConfigurationArn(`value`: Output<String>) {
        this.infrastructureConfigurationArn = value
    }

    /**
     * @param value Name of the image pipeline.
     * The following arguments are optional:
     */
    @JvmName("ucsmyvsseykdpoxd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration block with schedule settings. Detailed below.
     */
    @JvmName("pbkibfmvdhwogjsb")
    public suspend fun schedule(`value`: Output<ImagePipelineScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value Status of the image pipeline. Valid values are `DISABLED` and `ENABLED`. Defaults to `ENABLED`.
     */
    @JvmName("tlvbnlrfrlwrxxla")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Key-value map of resource tags for the image pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mvsjhelsicctvwql")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("blyugndsmgwvwdav")
    public suspend fun workflows(`value`: Output<List<ImagePipelineWorkflowArgs>>) {
        this.workflows = value
    }

    @JvmName("selgqneyhqembtyu")
    public suspend fun workflows(vararg values: Output<ImagePipelineWorkflowArgs>) {
        this.workflows = Output.all(values.asList())
    }

    /**
     * @param values Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("xuvvionvfmatcmig")
    public suspend fun workflows(values: List<Output<ImagePipelineWorkflowArgs>>) {
        this.workflows = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the container recipe.
     */
    @JvmName("layeiwxqskfuacxj")
    public suspend fun containerRecipeArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerRecipeArn = mapped
    }

    /**
     * @param value Description of the image pipeline.
     */
    @JvmName("skkenwylsabdhtjy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Distribution Configuration.
     */
    @JvmName("ohotikkexguookxd")
    public suspend fun distributionConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distributionConfigurationArn = mapped
    }

    /**
     * @param value Whether additional information about the image being created is collected. Defaults to `true`.
     */
    @JvmName("olftixjvyngdsxto")
    public suspend fun enhancedImageMetadataEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enhancedImageMetadataEnabled = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the service-linked role to be used by Image Builder to [execute workflows](https://docs.aws.amazon.com/imagebuilder/latest/userguide/manage-image-workflows.html).
     */
    @JvmName("vokuueojamuiusft")
    public suspend fun executionRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionRole = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the image recipe.
     */
    @JvmName("godtubsvqrgamibf")
    public suspend fun imageRecipeArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageRecipeArn = mapped
    }

    /**
     * @param value Configuration block with image scanning configuration. Detailed below.
     */
    @JvmName("vffvlfnympesjtgh")
    public suspend fun imageScanningConfiguration(`value`: ImagePipelineImageScanningConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageScanningConfiguration = mapped
    }

    /**
     * @param argument Configuration block with image scanning configuration. Detailed below.
     */
    @JvmName("vwpmocufwlirmxqh")
    public suspend fun imageScanningConfiguration(argument: suspend ImagePipelineImageScanningConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ImagePipelineImageScanningConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.imageScanningConfiguration = mapped
    }

    /**
     * @param value Configuration block with image tests configuration. Detailed below.
     */
    @JvmName("gqatvghrenpleane")
    public suspend fun imageTestsConfiguration(`value`: ImagePipelineImageTestsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageTestsConfiguration = mapped
    }

    /**
     * @param argument Configuration block with image tests configuration. Detailed below.
     */
    @JvmName("amjnewqkrfgqduqh")
    public suspend fun imageTestsConfiguration(argument: suspend ImagePipelineImageTestsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ImagePipelineImageTestsConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.imageTestsConfiguration = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Infrastructure Configuration.
     */
    @JvmName("xmoxpqlggqjhcoyk")
    public suspend fun infrastructureConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureConfigurationArn = mapped
    }

    /**
     * @param value Name of the image pipeline.
     * The following arguments are optional:
     */
    @JvmName("kipaldrmwsthxrjv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration block with schedule settings. Detailed below.
     */
    @JvmName("ktfjlueqfawnykkj")
    public suspend fun schedule(`value`: ImagePipelineScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Configuration block with schedule settings. Detailed below.
     */
    @JvmName("xxqcttuktuddqpnn")
    public suspend fun schedule(argument: suspend ImagePipelineScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = ImagePipelineScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value Status of the image pipeline. Valid values are `DISABLED` and `ENABLED`. Defaults to `ENABLED`.
     */
    @JvmName("edxjniyrqrxcwynk")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Key-value map of resource tags for the image pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kcdfpvmhxtriiyba")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the image pipeline. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qnpmblloufdlacsv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("mdxrraxkilsmnrsq")
    public suspend fun workflows(`value`: List<ImagePipelineWorkflowArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflows = mapped
    }

    /**
     * @param argument Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("gsnwtxjdoicfgoew")
    public suspend fun workflows(argument: List<suspend ImagePipelineWorkflowArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImagePipelineWorkflowArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.workflows = mapped
    }

    /**
     * @param argument Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("oveqbqudoqbleajq")
    public suspend fun workflows(vararg argument: suspend ImagePipelineWorkflowArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImagePipelineWorkflowArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.workflows = mapped
    }

    /**
     * @param argument Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("igkpahkvkpdwvvhe")
    public suspend fun workflows(argument: suspend ImagePipelineWorkflowArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ImagePipelineWorkflowArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.workflows = mapped
    }

    /**
     * @param values Configuration block with the workflow configuration. Detailed below.
     */
    @JvmName("vvgtmqktpyuxoosy")
    public suspend fun workflows(vararg values: ImagePipelineWorkflowArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workflows = mapped
    }

    internal fun build(): ImagePipelineArgs = ImagePipelineArgs(
        containerRecipeArn = containerRecipeArn,
        description = description,
        distributionConfigurationArn = distributionConfigurationArn,
        enhancedImageMetadataEnabled = enhancedImageMetadataEnabled,
        executionRole = executionRole,
        imageRecipeArn = imageRecipeArn,
        imageScanningConfiguration = imageScanningConfiguration,
        imageTestsConfiguration = imageTestsConfiguration,
        infrastructureConfigurationArn = infrastructureConfigurationArn,
        name = name,
        schedule = schedule,
        status = status,
        tags = tags,
        workflows = workflows,
    )
}
