@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.ImageRecipeArgs.builder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageRecipeBlockDeviceMappingArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageRecipeBlockDeviceMappingArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageRecipeComponentArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageRecipeComponentArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageRecipeSystemsManagerAgentArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.ImageRecipeSystemsManagerAgentArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Image Builder Image Recipe.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.imagebuilder.ImageRecipe("example", {
 *     blockDeviceMappings: [{
 *         deviceName: "/dev/xvdb",
 *         ebs: {
 *             deleteOnTermination: "true",
 *             volumeSize: 100,
 *             volumeType: "gp2",
 *         },
 *     }],
 *     components: [{
 *         componentArn: exampleAwsImagebuilderComponent.arn,
 *         parameters: [
 *             {
 *                 name: "Parameter1",
 *                 value: "Value1",
 *             },
 *             {
 *                 name: "Parameter2",
 *                 value: "Value2",
 *             },
 *         ],
 *     }],
 *     name: "example",
 *     parentImage: `arn:${current.partition}:imagebuilder:${currentAwsRegion.name}:aws:image/amazon-linux-2-x86/x.x.x`,
 *     version: "1.0.0",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.imagebuilder.ImageRecipe("example",
 *     block_device_mappings=[{
 *         "device_name": "/dev/xvdb",
 *         "ebs": {
 *             "delete_on_termination": "true",
 *             "volume_size": 100,
 *             "volume_type": "gp2",
 *         },
 *     }],
 *     components=[{
 *         "component_arn": example_aws_imagebuilder_component["arn"],
 *         "parameters": [
 *             {
 *                 "name": "Parameter1",
 *                 "value": "Value1",
 *             },
 *             {
 *                 "name": "Parameter2",
 *                 "value": "Value2",
 *             },
 *         ],
 *     }],
 *     name="example",
 *     parent_image=f"arn:{current['partition']}:imagebuilder:{current_aws_region['name']}:aws:image/amazon-linux-2-x86/x.x.x",
 *     version="1.0.0")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ImageBuilder.ImageRecipe("example", new()
 *     {
 *         BlockDeviceMappings = new[]
 *         {
 *             new Aws.ImageBuilder.Inputs.ImageRecipeBlockDeviceMappingArgs
 *             {
 *                 DeviceName = "/dev/xvdb",
 *                 Ebs = new Aws.ImageBuilder.Inputs.ImageRecipeBlockDeviceMappingEbsArgs
 *                 {
 *                     DeleteOnTermination = "true",
 *                     VolumeSize = 100,
 *                     VolumeType = "gp2",
 *                 },
 *             },
 *         },
 *         Components = new[]
 *         {
 *             new Aws.ImageBuilder.Inputs.ImageRecipeComponentArgs
 *             {
 *                 ComponentArn = exampleAwsImagebuilderComponent.Arn,
 *                 Parameters = new[]
 *                 {
 *                     new Aws.ImageBuilder.Inputs.ImageRecipeComponentParameterArgs
 *                     {
 *                         Name = "Parameter1",
 *                         Value = "Value1",
 *                     },
 *                     new Aws.ImageBuilder.Inputs.ImageRecipeComponentParameterArgs
 *                     {
 *                         Name = "Parameter2",
 *                         Value = "Value2",
 *                     },
 *                 },
 *             },
 *         },
 *         Name = "example",
 *         ParentImage = $"arn:{current.Partition}:imagebuilder:{currentAwsRegion.Name}:aws:image/amazon-linux-2-x86/x.x.x",
 *         Version = "1.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/imagebuilder"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := imagebuilder.NewImageRecipe(ctx, "example", &imagebuilder.ImageRecipeArgs{
 * 			BlockDeviceMappings: imagebuilder.ImageRecipeBlockDeviceMappingArray{
 * 				&imagebuilder.ImageRecipeBlockDeviceMappingArgs{
 * 					DeviceName: pulumi.String("/dev/xvdb"),
 * 					Ebs: &imagebuilder.ImageRecipeBlockDeviceMappingEbsArgs{
 * 						DeleteOnTermination: pulumi.String("true"),
 * 						VolumeSize:          pulumi.Int(100),
 * 						VolumeType:          pulumi.String("gp2"),
 * 					},
 * 				},
 * 			},
 * 			Components: imagebuilder.ImageRecipeComponentArray{
 * 				&imagebuilder.ImageRecipeComponentArgs{
 * 					ComponentArn: pulumi.Any(exampleAwsImagebuilderComponent.Arn),
 * 					Parameters: imagebuilder.ImageRecipeComponentParameterArray{
 * 						&imagebuilder.ImageRecipeComponentParameterArgs{
 * 							Name:  pulumi.String("Parameter1"),
 * 							Value: pulumi.String("Value1"),
 * 						},
 * 						&imagebuilder.ImageRecipeComponentParameterArgs{
 * 							Name:  pulumi.String("Parameter2"),
 * 							Value: pulumi.String("Value2"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Name:        pulumi.String("example"),
 * 			ParentImage: pulumi.Sprintf("arn:%v:imagebuilder:%v:aws:image/amazon-linux-2-x86/x.x.x", current.Partition, currentAwsRegion.Name),
 * 			Version:     pulumi.String("1.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.ImageRecipe;
 * import com.pulumi.aws.imagebuilder.ImageRecipeArgs;
 * import com.pulumi.aws.imagebuilder.inputs.ImageRecipeBlockDeviceMappingArgs;
 * import com.pulumi.aws.imagebuilder.inputs.ImageRecipeBlockDeviceMappingEbsArgs;
 * import com.pulumi.aws.imagebuilder.inputs.ImageRecipeComponentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ImageRecipe("example", ImageRecipeArgs.builder()
 *             .blockDeviceMappings(ImageRecipeBlockDeviceMappingArgs.builder()
 *                 .deviceName("/dev/xvdb")
 *                 .ebs(ImageRecipeBlockDeviceMappingEbsArgs.builder()
 *                     .deleteOnTermination(true)
 *                     .volumeSize(100)
 *                     .volumeType("gp2")
 *                     .build())
 *                 .build())
 *             .components(ImageRecipeComponentArgs.builder()
 *                 .componentArn(exampleAwsImagebuilderComponent.arn())
 *                 .parameters(
 *                     ImageRecipeComponentParameterArgs.builder()
 *                         .name("Parameter1")
 *                         .value("Value1")
 *                         .build(),
 *                     ImageRecipeComponentParameterArgs.builder()
 *                         .name("Parameter2")
 *                         .value("Value2")
 *                         .build())
 *                 .build())
 *             .name("example")
 *             .parentImage(String.format("arn:%s:imagebuilder:%s:aws:image/amazon-linux-2-x86/x.x.x", current.partition(),currentAwsRegion.name()))
 *             .version("1.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:imagebuilder:ImageRecipe
 *     properties:
 *       blockDeviceMappings:
 *         - deviceName: /dev/xvdb
 *           ebs:
 *             deleteOnTermination: true
 *             volumeSize: 100
 *             volumeType: gp2
 *       components:
 *         - componentArn: ${exampleAwsImagebuilderComponent.arn}
 *           parameters:
 *             - name: Parameter1
 *               value: Value1
 *             - name: Parameter2
 *               value: Value2
 *       name: example
 *       parentImage: arn:${current.partition}:imagebuilder:${currentAwsRegion.name}:aws:image/amazon-linux-2-x86/x.x.x
 *       version: 1.0.0
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_image_recipe` resources using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:imagebuilder/imageRecipe:ImageRecipe example arn:aws:imagebuilder:us-east-1:123456789012:image-recipe/example/1.0.0
 * ```
 * @property blockDeviceMappings Configuration block(s) with block device mappings for the image recipe. Detailed below.
 * @property components Ordered configuration block(s) with components for the image recipe. Detailed below.
 * @property description Description of the image recipe.
 * @property name Name of the image recipe.
 * @property parentImage The image recipe uses this image as a base from which to build your customized image. The value can be the base image ARN or an AMI ID.
 * @property systemsManagerAgent Configuration block for the Systems Manager Agent installed by default by Image Builder. Detailed below.
 * @property tags Key-value map of resource tags for the image recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userDataBase64 Base64 encoded user data. Use this to provide commands or a command script to run when you launch your build instance.
 * @property version The semantic version of the image recipe, which specifies the version in the following format, with numeric values in each position to indicate a specific version: major.minor.patch. For example: 1.0.0.
 * The following attributes are optional:
 * @property workingDirectory The working directory to be used during build and test workflows.
 */
public data class ImageRecipeArgs(
    public val blockDeviceMappings: Output<List<ImageRecipeBlockDeviceMappingArgs>>? = null,
    public val components: Output<List<ImageRecipeComponentArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parentImage: Output<String>? = null,
    public val systemsManagerAgent: Output<ImageRecipeSystemsManagerAgentArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userDataBase64: Output<String>? = null,
    public val version: Output<String>? = null,
    public val workingDirectory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.ImageRecipeArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.ImageRecipeArgs =
        com.pulumi.aws.imagebuilder.ImageRecipeArgs.builder()
            .blockDeviceMappings(
                blockDeviceMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .components(
                components?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parentImage(parentImage?.applyValue({ args0 -> args0 }))
            .systemsManagerAgent(
                systemsManagerAgent?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userDataBase64(userDataBase64?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 }))
            .workingDirectory(workingDirectory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageRecipeArgs].
 */
@PulumiTagMarker
public class ImageRecipeArgsBuilder internal constructor() {
    private var blockDeviceMappings: Output<List<ImageRecipeBlockDeviceMappingArgs>>? = null

    private var components: Output<List<ImageRecipeComponentArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var parentImage: Output<String>? = null

    private var systemsManagerAgent: Output<ImageRecipeSystemsManagerAgentArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userDataBase64: Output<String>? = null

    private var version: Output<String>? = null

    private var workingDirectory: Output<String>? = null

    /**
     * @param value Configuration block(s) with block device mappings for the image recipe. Detailed below.
     */
    @JvmName("tavyeiqmfdufsxgk")
    public suspend fun blockDeviceMappings(`value`: Output<List<ImageRecipeBlockDeviceMappingArgs>>) {
        this.blockDeviceMappings = value
    }

    @JvmName("unbmshsocfqvxebq")
    public suspend fun blockDeviceMappings(vararg values: Output<ImageRecipeBlockDeviceMappingArgs>) {
        this.blockDeviceMappings = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) with block device mappings for the image recipe. Detailed below.
     */
    @JvmName("mkpwuykfujhnvffy")
    public suspend fun blockDeviceMappings(values: List<Output<ImageRecipeBlockDeviceMappingArgs>>) {
        this.blockDeviceMappings = Output.all(values)
    }

    /**
     * @param value Ordered configuration block(s) with components for the image recipe. Detailed below.
     */
    @JvmName("amresinblhyqaygy")
    public suspend fun components(`value`: Output<List<ImageRecipeComponentArgs>>) {
        this.components = value
    }

    @JvmName("jimwwjsqyajvnokr")
    public suspend fun components(vararg values: Output<ImageRecipeComponentArgs>) {
        this.components = Output.all(values.asList())
    }

    /**
     * @param values Ordered configuration block(s) with components for the image recipe. Detailed below.
     */
    @JvmName("xhqhyqgkiesdvwmy")
    public suspend fun components(values: List<Output<ImageRecipeComponentArgs>>) {
        this.components = Output.all(values)
    }

    /**
     * @param value Description of the image recipe.
     */
    @JvmName("seesircblmvrygqr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the image recipe.
     */
    @JvmName("faqgfwsebhwhqgar")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The image recipe uses this image as a base from which to build your customized image. The value can be the base image ARN or an AMI ID.
     */
    @JvmName("fgxrkcgbhfogfjkv")
    public suspend fun parentImage(`value`: Output<String>) {
        this.parentImage = value
    }

    /**
     * @param value Configuration block for the Systems Manager Agent installed by default by Image Builder. Detailed below.
     */
    @JvmName("fgtnnpsgsthwaquy")
    public suspend fun systemsManagerAgent(`value`: Output<ImageRecipeSystemsManagerAgentArgs>) {
        this.systemsManagerAgent = value
    }

    /**
     * @param value Key-value map of resource tags for the image recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nkaicoxjybxmueoe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Base64 encoded user data. Use this to provide commands or a command script to run when you launch your build instance.
     */
    @JvmName("rwywaeyilitxxopo")
    public suspend fun userDataBase64(`value`: Output<String>) {
        this.userDataBase64 = value
    }

    /**
     * @param value The semantic version of the image recipe, which specifies the version in the following format, with numeric values in each position to indicate a specific version: major.minor.patch. For example: 1.0.0.
     * The following attributes are optional:
     */
    @JvmName("avsvlweorojevdgn")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The working directory to be used during build and test workflows.
     */
    @JvmName("hrrsmtubdmxxurvt")
    public suspend fun workingDirectory(`value`: Output<String>) {
        this.workingDirectory = value
    }

    /**
     * @param value Configuration block(s) with block device mappings for the image recipe. Detailed below.
     */
    @JvmName("pvpluewpmspxxgad")
    public suspend fun blockDeviceMappings(`value`: List<ImageRecipeBlockDeviceMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockDeviceMappings = mapped
    }

    /**
     * @param argument Configuration block(s) with block device mappings for the image recipe. Detailed below.
     */
    @JvmName("olfnlvyukradrlrb")
    public suspend fun blockDeviceMappings(argument: List<suspend ImageRecipeBlockDeviceMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImageRecipeBlockDeviceMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.blockDeviceMappings = mapped
    }

    /**
     * @param argument Configuration block(s) with block device mappings for the image recipe. Detailed below.
     */
    @JvmName("usvrwvipvqruwbps")
    public suspend fun blockDeviceMappings(vararg argument: suspend ImageRecipeBlockDeviceMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImageRecipeBlockDeviceMappingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.blockDeviceMappings = mapped
    }

    /**
     * @param argument Configuration block(s) with block device mappings for the image recipe. Detailed below.
     */
    @JvmName("ssdiqmsfvljjjomq")
    public suspend fun blockDeviceMappings(argument: suspend ImageRecipeBlockDeviceMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ImageRecipeBlockDeviceMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.blockDeviceMappings = mapped
    }

    /**
     * @param values Configuration block(s) with block device mappings for the image recipe. Detailed below.
     */
    @JvmName("ldkdeeybtsomkswo")
    public suspend fun blockDeviceMappings(vararg values: ImageRecipeBlockDeviceMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blockDeviceMappings = mapped
    }

    /**
     * @param value Ordered configuration block(s) with components for the image recipe. Detailed below.
     */
    @JvmName("lcusevdfatpppjib")
    public suspend fun components(`value`: List<ImageRecipeComponentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param argument Ordered configuration block(s) with components for the image recipe. Detailed below.
     */
    @JvmName("qldvslncyqicwpja")
    public suspend fun components(argument: List<suspend ImageRecipeComponentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImageRecipeComponentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param argument Ordered configuration block(s) with components for the image recipe. Detailed below.
     */
    @JvmName("fflsqexqljjdpegv")
    public suspend fun components(vararg argument: suspend ImageRecipeComponentArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImageRecipeComponentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param argument Ordered configuration block(s) with components for the image recipe. Detailed below.
     */
    @JvmName("njsupoltjqjiypnn")
    public suspend fun components(argument: suspend ImageRecipeComponentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ImageRecipeComponentArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.components = mapped
    }

    /**
     * @param values Ordered configuration block(s) with components for the image recipe. Detailed below.
     */
    @JvmName("xwytxpdbiwqjwkaa")
    public suspend fun components(vararg values: ImageRecipeComponentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.components = mapped
    }

    /**
     * @param value Description of the image recipe.
     */
    @JvmName("wregplxkdihelayd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the image recipe.
     */
    @JvmName("xkcupdebslulnfov")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The image recipe uses this image as a base from which to build your customized image. The value can be the base image ARN or an AMI ID.
     */
    @JvmName("jouykewdfbyxmkfe")
    public suspend fun parentImage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentImage = mapped
    }

    /**
     * @param value Configuration block for the Systems Manager Agent installed by default by Image Builder. Detailed below.
     */
    @JvmName("wtfoukblapdhndbo")
    public suspend fun systemsManagerAgent(`value`: ImageRecipeSystemsManagerAgentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.systemsManagerAgent = mapped
    }

    /**
     * @param argument Configuration block for the Systems Manager Agent installed by default by Image Builder. Detailed below.
     */
    @JvmName("iilopueeqihecjen")
    public suspend fun systemsManagerAgent(argument: suspend ImageRecipeSystemsManagerAgentArgsBuilder.() -> Unit) {
        val toBeMapped = ImageRecipeSystemsManagerAgentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.systemsManagerAgent = mapped
    }

    /**
     * @param value Key-value map of resource tags for the image recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nyojjogdqdgrqgyv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the image recipe. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bxycdowkwqxyyclt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Base64 encoded user data. Use this to provide commands or a command script to run when you launch your build instance.
     */
    @JvmName("ahgwrxiehnelylon")
    public suspend fun userDataBase64(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userDataBase64 = mapped
    }

    /**
     * @param value The semantic version of the image recipe, which specifies the version in the following format, with numeric values in each position to indicate a specific version: major.minor.patch. For example: 1.0.0.
     * The following attributes are optional:
     */
    @JvmName("eooxyjhravsbxxva")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value The working directory to be used during build and test workflows.
     */
    @JvmName("ipltdptuduvfnpyk")
    public suspend fun workingDirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workingDirectory = mapped
    }

    internal fun build(): ImageRecipeArgs = ImageRecipeArgs(
        blockDeviceMappings = blockDeviceMappings,
        components = components,
        description = description,
        name = name,
        parentImage = parentImage,
        systemsManagerAgent = systemsManagerAgent,
        tags = tags,
        userDataBase64 = userDataBase64,
        version = version,
        workingDirectory = workingDirectory,
    )
}
