@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.kotlin.outputs.InfrastructureConfigurationInstanceMetadataOptions
import com.pulumi.aws.imagebuilder.kotlin.outputs.InfrastructureConfigurationLogging
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.imagebuilder.kotlin.outputs.InfrastructureConfigurationInstanceMetadataOptions.Companion.toKotlin as infrastructureConfigurationInstanceMetadataOptionsToKotlin
import com.pulumi.aws.imagebuilder.kotlin.outputs.InfrastructureConfigurationLogging.Companion.toKotlin as infrastructureConfigurationLoggingToKotlin

/**
 * Builder for [InfrastructureConfiguration].
 */
@PulumiTagMarker
public class InfrastructureConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InfrastructureConfigurationArgs = InfrastructureConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InfrastructureConfigurationArgsBuilder.() -> Unit) {
        val builder = InfrastructureConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InfrastructureConfiguration {
        val builtJavaResource =
            com.pulumi.aws.imagebuilder.InfrastructureConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InfrastructureConfiguration(builtJavaResource)
    }
}

/**
 * Manages an Image Builder Infrastructure Configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.imagebuilder.InfrastructureConfiguration("example", {
 *     description: "example description",
 *     instanceProfileName: exampleAwsIamInstanceProfile.name,
 *     instanceTypes: [
 *         "t2.nano",
 *         "t3.micro",
 *     ],
 *     keyPair: exampleAwsKeyPair.keyName,
 *     name: "example",
 *     securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *     snsTopicArn: exampleAwsSnsTopic.arn,
 *     subnetId: main.id,
 *     terminateInstanceOnFailure: true,
 *     logging: {
 *         s3Logs: {
 *             s3BucketName: exampleAwsS3Bucket.bucket,
 *             s3KeyPrefix: "logs",
 *         },
 *     },
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.imagebuilder.InfrastructureConfiguration("example",
 *     description="example description",
 *     instance_profile_name=example_aws_iam_instance_profile["name"],
 *     instance_types=[
 *         "t2.nano",
 *         "t3.micro",
 *     ],
 *     key_pair=example_aws_key_pair["keyName"],
 *     name="example",
 *     security_group_ids=[example_aws_security_group["id"]],
 *     sns_topic_arn=example_aws_sns_topic["arn"],
 *     subnet_id=main["id"],
 *     terminate_instance_on_failure=True,
 *     logging={
 *         "s3_logs": {
 *             "s3_bucket_name": example_aws_s3_bucket["bucket"],
 *             "s3_key_prefix": "logs",
 *         },
 *     },
 *     tags={
 *         "foo": "bar",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ImageBuilder.InfrastructureConfiguration("example", new()
 *     {
 *         Description = "example description",
 *         InstanceProfileName = exampleAwsIamInstanceProfile.Name,
 *         InstanceTypes = new[]
 *         {
 *             "t2.nano",
 *             "t3.micro",
 *         },
 *         KeyPair = exampleAwsKeyPair.KeyName,
 *         Name = "example",
 *         SecurityGroupIds = new[]
 *         {
 *             exampleAwsSecurityGroup.Id,
 *         },
 *         SnsTopicArn = exampleAwsSnsTopic.Arn,
 *         SubnetId = main.Id,
 *         TerminateInstanceOnFailure = true,
 *         Logging = new Aws.ImageBuilder.Inputs.InfrastructureConfigurationLoggingArgs
 *         {
 *             S3Logs = new Aws.ImageBuilder.Inputs.InfrastructureConfigurationLoggingS3LogsArgs
 *             {
 *                 S3BucketName = exampleAwsS3Bucket.Bucket,
 *                 S3KeyPrefix = "logs",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/imagebuilder"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := imagebuilder.NewInfrastructureConfiguration(ctx, "example", &imagebuilder.InfrastructureConfigurationArgs{
 * 			Description:         pulumi.String("example description"),
 * 			InstanceProfileName: pulumi.Any(exampleAwsIamInstanceProfile.Name),
 * 			InstanceTypes: pulumi.StringArray{
 * 				pulumi.String("t2.nano"),
 * 				pulumi.String("t3.micro"),
 * 			},
 * 			KeyPair: pulumi.Any(exampleAwsKeyPair.KeyName),
 * 			Name:    pulumi.String("example"),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Id,
 * 			},
 * 			SnsTopicArn:                pulumi.Any(exampleAwsSnsTopic.Arn),
 * 			SubnetId:                   pulumi.Any(main.Id),
 * 			TerminateInstanceOnFailure: pulumi.Bool(true),
 * 			Logging: &imagebuilder.InfrastructureConfigurationLoggingArgs{
 * 				S3Logs: &imagebuilder.InfrastructureConfigurationLoggingS3LogsArgs{
 * 					S3BucketName: pulumi.Any(exampleAwsS3Bucket.Bucket),
 * 					S3KeyPrefix:  pulumi.String("logs"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.InfrastructureConfiguration;
 * import com.pulumi.aws.imagebuilder.InfrastructureConfigurationArgs;
 * import com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationLoggingArgs;
 * import com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationLoggingS3LogsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InfrastructureConfiguration("example", InfrastructureConfigurationArgs.builder()
 *             .description("example description")
 *             .instanceProfileName(exampleAwsIamInstanceProfile.name())
 *             .instanceTypes(
 *                 "t2.nano",
 *                 "t3.micro")
 *             .keyPair(exampleAwsKeyPair.keyName())
 *             .name("example")
 *             .securityGroupIds(exampleAwsSecurityGroup.id())
 *             .snsTopicArn(exampleAwsSnsTopic.arn())
 *             .subnetId(main.id())
 *             .terminateInstanceOnFailure(true)
 *             .logging(InfrastructureConfigurationLoggingArgs.builder()
 *                 .s3Logs(InfrastructureConfigurationLoggingS3LogsArgs.builder()
 *                     .s3BucketName(exampleAwsS3Bucket.bucket())
 *                     .s3KeyPrefix("logs")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:imagebuilder:InfrastructureConfiguration
 *     properties:
 *       description: example description
 *       instanceProfileName: ${exampleAwsIamInstanceProfile.name}
 *       instanceTypes:
 *         - t2.nano
 *         - t3.micro
 *       keyPair: ${exampleAwsKeyPair.keyName}
 *       name: example
 *       securityGroupIds:
 *         - ${exampleAwsSecurityGroup.id}
 *       snsTopicArn: ${exampleAwsSnsTopic.arn}
 *       subnetId: ${main.id}
 *       terminateInstanceOnFailure: true
 *       logging:
 *         s3Logs:
 *           s3BucketName: ${exampleAwsS3Bucket.bucket}
 *           s3KeyPrefix: logs
 *       tags:
 *         foo: bar
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_infrastructure_configuration` using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:imagebuilder/infrastructureConfiguration:InfrastructureConfiguration example arn:aws:imagebuilder:us-east-1:123456789012:infrastructure-configuration/example
 * ```
 */
public class InfrastructureConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.imagebuilder.InfrastructureConfiguration,
) : KotlinCustomResource(javaResource, InfrastructureConfigurationMapper) {
    /**
     * Amazon Resource Name (ARN) of the configuration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Date when the configuration was created.
     */
    public val dateCreated: Output<String>
        get() = javaResource.dateCreated().applyValue({ args0 -> args0 })

    /**
     * Date when the configuration was updated.
     */
    public val dateUpdated: Output<String>
        get() = javaResource.dateUpdated().applyValue({ args0 -> args0 })

    /**
     * Description for the configuration.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block with instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances. Detailed below.
     */
    public val instanceMetadataOptions: Output<InfrastructureConfigurationInstanceMetadataOptions>?
        get() = javaResource.instanceMetadataOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    infrastructureConfigurationInstanceMetadataOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Name of IAM Instance Profile.
     */
    public val instanceProfileName: Output<String>
        get() = javaResource.instanceProfileName().applyValue({ args0 -> args0 })

    /**
     * Set of EC2 Instance Types.
     */
    public val instanceTypes: Output<List<String>>?
        get() = javaResource.instanceTypes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Name of EC2 Key Pair.
     */
    public val keyPair: Output<String>?
        get() = javaResource.keyPair().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Configuration block with logging settings. Detailed below.
     */
    public val logging: Output<InfrastructureConfigurationLogging>?
        get() = javaResource.logging().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    infrastructureConfigurationLoggingToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Name for the configuration.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags to assign to infrastructure created by the configuration.
     */
    public val resourceTags: Output<Map<String, String>>?
        get() = javaResource.resourceTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Set of EC2 Security Group identifiers.
     */
    public val securityGroupIds: Output<List<String>>?
        get() = javaResource.securityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of SNS Topic.
     */
    public val snsTopicArn: Output<String>?
        get() = javaResource.snsTopicArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * EC2 Subnet identifier. Also requires `security_group_ids` argument.
     */
    public val subnetId: Output<String>?
        get() = javaResource.subnetId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Key-value map of resource tags to assign to the configuration. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Enable if the instance should be terminated when the pipeline fails. Defaults to `false`.
     */
    public val terminateInstanceOnFailure: Output<Boolean>?
        get() = javaResource.terminateInstanceOnFailure().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object InfrastructureConfigurationMapper : ResourceMapper<InfrastructureConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.imagebuilder.InfrastructureConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): InfrastructureConfiguration =
        InfrastructureConfiguration(
            javaResource as
                com.pulumi.aws.imagebuilder.InfrastructureConfiguration,
        )
}

/**
 * @see [InfrastructureConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InfrastructureConfiguration].
 */
public suspend fun infrastructureConfiguration(
    name: String,
    block: suspend InfrastructureConfigurationResourceBuilder.() -> Unit,
): InfrastructureConfiguration {
    val builder = InfrastructureConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InfrastructureConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun infrastructureConfiguration(name: String): InfrastructureConfiguration {
    val builder = InfrastructureConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
