@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.InfrastructureConfigurationArgs.builder
import com.pulumi.aws.imagebuilder.kotlin.inputs.InfrastructureConfigurationInstanceMetadataOptionsArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.InfrastructureConfigurationInstanceMetadataOptionsArgsBuilder
import com.pulumi.aws.imagebuilder.kotlin.inputs.InfrastructureConfigurationLoggingArgs
import com.pulumi.aws.imagebuilder.kotlin.inputs.InfrastructureConfigurationLoggingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Image Builder Infrastructure Configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.imagebuilder.InfrastructureConfiguration("example", {
 *     description: "example description",
 *     instanceProfileName: exampleAwsIamInstanceProfile.name,
 *     instanceTypes: [
 *         "t2.nano",
 *         "t3.micro",
 *     ],
 *     keyPair: exampleAwsKeyPair.keyName,
 *     name: "example",
 *     securityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *     snsTopicArn: exampleAwsSnsTopic.arn,
 *     subnetId: main.id,
 *     terminateInstanceOnFailure: true,
 *     logging: {
 *         s3Logs: {
 *             s3BucketName: exampleAwsS3Bucket.bucket,
 *             s3KeyPrefix: "logs",
 *         },
 *     },
 *     tags: {
 *         foo: "bar",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.imagebuilder.InfrastructureConfiguration("example",
 *     description="example description",
 *     instance_profile_name=example_aws_iam_instance_profile["name"],
 *     instance_types=[
 *         "t2.nano",
 *         "t3.micro",
 *     ],
 *     key_pair=example_aws_key_pair["keyName"],
 *     name="example",
 *     security_group_ids=[example_aws_security_group["id"]],
 *     sns_topic_arn=example_aws_sns_topic["arn"],
 *     subnet_id=main["id"],
 *     terminate_instance_on_failure=True,
 *     logging={
 *         "s3_logs": {
 *             "s3_bucket_name": example_aws_s3_bucket["bucket"],
 *             "s3_key_prefix": "logs",
 *         },
 *     },
 *     tags={
 *         "foo": "bar",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ImageBuilder.InfrastructureConfiguration("example", new()
 *     {
 *         Description = "example description",
 *         InstanceProfileName = exampleAwsIamInstanceProfile.Name,
 *         InstanceTypes = new[]
 *         {
 *             "t2.nano",
 *             "t3.micro",
 *         },
 *         KeyPair = exampleAwsKeyPair.KeyName,
 *         Name = "example",
 *         SecurityGroupIds = new[]
 *         {
 *             exampleAwsSecurityGroup.Id,
 *         },
 *         SnsTopicArn = exampleAwsSnsTopic.Arn,
 *         SubnetId = main.Id,
 *         TerminateInstanceOnFailure = true,
 *         Logging = new Aws.ImageBuilder.Inputs.InfrastructureConfigurationLoggingArgs
 *         {
 *             S3Logs = new Aws.ImageBuilder.Inputs.InfrastructureConfigurationLoggingS3LogsArgs
 *             {
 *                 S3BucketName = exampleAwsS3Bucket.Bucket,
 *                 S3KeyPrefix = "logs",
 *             },
 *         },
 *         Tags =
 *         {
 *             { "foo", "bar" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/imagebuilder"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := imagebuilder.NewInfrastructureConfiguration(ctx, "example", &imagebuilder.InfrastructureConfigurationArgs{
 * 			Description:         pulumi.String("example description"),
 * 			InstanceProfileName: pulumi.Any(exampleAwsIamInstanceProfile.Name),
 * 			InstanceTypes: pulumi.StringArray{
 * 				pulumi.String("t2.nano"),
 * 				pulumi.String("t3.micro"),
 * 			},
 * 			KeyPair: pulumi.Any(exampleAwsKeyPair.KeyName),
 * 			Name:    pulumi.String("example"),
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Id,
 * 			},
 * 			SnsTopicArn:                pulumi.Any(exampleAwsSnsTopic.Arn),
 * 			SubnetId:                   pulumi.Any(main.Id),
 * 			TerminateInstanceOnFailure: pulumi.Bool(true),
 * 			Logging: &imagebuilder.InfrastructureConfigurationLoggingArgs{
 * 				S3Logs: &imagebuilder.InfrastructureConfigurationLoggingS3LogsArgs{
 * 					S3BucketName: pulumi.Any(exampleAwsS3Bucket.Bucket),
 * 					S3KeyPrefix:  pulumi.String("logs"),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"foo": pulumi.String("bar"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.InfrastructureConfiguration;
 * import com.pulumi.aws.imagebuilder.InfrastructureConfigurationArgs;
 * import com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationLoggingArgs;
 * import com.pulumi.aws.imagebuilder.inputs.InfrastructureConfigurationLoggingS3LogsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InfrastructureConfiguration("example", InfrastructureConfigurationArgs.builder()
 *             .description("example description")
 *             .instanceProfileName(exampleAwsIamInstanceProfile.name())
 *             .instanceTypes(
 *                 "t2.nano",
 *                 "t3.micro")
 *             .keyPair(exampleAwsKeyPair.keyName())
 *             .name("example")
 *             .securityGroupIds(exampleAwsSecurityGroup.id())
 *             .snsTopicArn(exampleAwsSnsTopic.arn())
 *             .subnetId(main.id())
 *             .terminateInstanceOnFailure(true)
 *             .logging(InfrastructureConfigurationLoggingArgs.builder()
 *                 .s3Logs(InfrastructureConfigurationLoggingS3LogsArgs.builder()
 *                     .s3BucketName(exampleAwsS3Bucket.bucket())
 *                     .s3KeyPrefix("logs")
 *                     .build())
 *                 .build())
 *             .tags(Map.of("foo", "bar"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:imagebuilder:InfrastructureConfiguration
 *     properties:
 *       description: example description
 *       instanceProfileName: ${exampleAwsIamInstanceProfile.name}
 *       instanceTypes:
 *         - t2.nano
 *         - t3.micro
 *       keyPair: ${exampleAwsKeyPair.keyName}
 *       name: example
 *       securityGroupIds:
 *         - ${exampleAwsSecurityGroup.id}
 *       snsTopicArn: ${exampleAwsSnsTopic.arn}
 *       subnetId: ${main.id}
 *       terminateInstanceOnFailure: true
 *       logging:
 *         s3Logs:
 *           s3BucketName: ${exampleAwsS3Bucket.bucket}
 *           s3KeyPrefix: logs
 *       tags:
 *         foo: bar
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_imagebuilder_infrastructure_configuration` using the Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:imagebuilder/infrastructureConfiguration:InfrastructureConfiguration example arn:aws:imagebuilder:us-east-1:123456789012:infrastructure-configuration/example
 * ```
 * @property description Description for the configuration.
 * @property instanceMetadataOptions Configuration block with instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances. Detailed below.
 * @property instanceProfileName Name of IAM Instance Profile.
 * @property instanceTypes Set of EC2 Instance Types.
 * @property keyPair Name of EC2 Key Pair.
 * @property logging Configuration block with logging settings. Detailed below.
 * @property name Name for the configuration.
 * The following arguments are optional:
 * @property resourceTags Key-value map of resource tags to assign to infrastructure created by the configuration.
 * @property securityGroupIds Set of EC2 Security Group identifiers.
 * @property snsTopicArn Amazon Resource Name (ARN) of SNS Topic.
 * @property subnetId EC2 Subnet identifier. Also requires `security_group_ids` argument.
 * @property tags Key-value map of resource tags to assign to the configuration. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property terminateInstanceOnFailure Enable if the instance should be terminated when the pipeline fails. Defaults to `false`.
 */
public data class InfrastructureConfigurationArgs(
    public val description: Output<String>? = null,
    public val instanceMetadataOptions: Output<InfrastructureConfigurationInstanceMetadataOptionsArgs>? = null,
    public val instanceProfileName: Output<String>? = null,
    public val instanceTypes: Output<List<String>>? = null,
    public val keyPair: Output<String>? = null,
    public val logging: Output<InfrastructureConfigurationLoggingArgs>? = null,
    public val name: Output<String>? = null,
    public val resourceTags: Output<Map<String, String>>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val snsTopicArn: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val terminateInstanceOnFailure: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.InfrastructureConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.InfrastructureConfigurationArgs =
        com.pulumi.aws.imagebuilder.InfrastructureConfigurationArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceMetadataOptions(
                instanceMetadataOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .instanceProfileName(instanceProfileName?.applyValue({ args0 -> args0 }))
            .instanceTypes(instanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyPair(keyPair?.applyValue({ args0 -> args0 }))
            .logging(logging?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .resourceTags(
                resourceTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .snsTopicArn(snsTopicArn?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .terminateInstanceOnFailure(terminateInstanceOnFailure?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InfrastructureConfigurationArgs].
 */
@PulumiTagMarker
public class InfrastructureConfigurationArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var instanceMetadataOptions:
        Output<InfrastructureConfigurationInstanceMetadataOptionsArgs>? = null

    private var instanceProfileName: Output<String>? = null

    private var instanceTypes: Output<List<String>>? = null

    private var keyPair: Output<String>? = null

    private var logging: Output<InfrastructureConfigurationLoggingArgs>? = null

    private var name: Output<String>? = null

    private var resourceTags: Output<Map<String, String>>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var snsTopicArn: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var terminateInstanceOnFailure: Output<Boolean>? = null

    /**
     * @param value Description for the configuration.
     */
    @JvmName("jviwgsnqlxeigjed")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Configuration block with instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances. Detailed below.
     */
    @JvmName("uiakvntueimtpkxn")
    public suspend fun instanceMetadataOptions(`value`: Output<InfrastructureConfigurationInstanceMetadataOptionsArgs>) {
        this.instanceMetadataOptions = value
    }

    /**
     * @param value Name of IAM Instance Profile.
     */
    @JvmName("kpxqtfgoiaxxxtoo")
    public suspend fun instanceProfileName(`value`: Output<String>) {
        this.instanceProfileName = value
    }

    /**
     * @param value Set of EC2 Instance Types.
     */
    @JvmName("uixjbjlrbpodqcju")
    public suspend fun instanceTypes(`value`: Output<List<String>>) {
        this.instanceTypes = value
    }

    @JvmName("srgpsxgsxtlgkrhd")
    public suspend fun instanceTypes(vararg values: Output<String>) {
        this.instanceTypes = Output.all(values.asList())
    }

    /**
     * @param values Set of EC2 Instance Types.
     */
    @JvmName("lnmmelpncpevqkkt")
    public suspend fun instanceTypes(values: List<Output<String>>) {
        this.instanceTypes = Output.all(values)
    }

    /**
     * @param value Name of EC2 Key Pair.
     */
    @JvmName("xloluhyttsqdthng")
    public suspend fun keyPair(`value`: Output<String>) {
        this.keyPair = value
    }

    /**
     * @param value Configuration block with logging settings. Detailed below.
     */
    @JvmName("qqlaconmvkjglfmf")
    public suspend fun logging(`value`: Output<InfrastructureConfigurationLoggingArgs>) {
        this.logging = value
    }

    /**
     * @param value Name for the configuration.
     * The following arguments are optional:
     */
    @JvmName("hensjcgiydompbqu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags to assign to infrastructure created by the configuration.
     */
    @JvmName("euyotwpxdxvodulr")
    public suspend fun resourceTags(`value`: Output<Map<String, String>>) {
        this.resourceTags = value
    }

    /**
     * @param value Set of EC2 Security Group identifiers.
     */
    @JvmName("bbgvlmskxjxqldlv")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("txvriukkretddexy")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Set of EC2 Security Group identifiers.
     */
    @JvmName("qoisxgjjnqfhsgyx")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of SNS Topic.
     */
    @JvmName("vhxchutqjpevqtgn")
    public suspend fun snsTopicArn(`value`: Output<String>) {
        this.snsTopicArn = value
    }

    /**
     * @param value EC2 Subnet identifier. Also requires `security_group_ids` argument.
     */
    @JvmName("secybyuoaranrfdm")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Key-value map of resource tags to assign to the configuration. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xyqtocauubvsovvr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Enable if the instance should be terminated when the pipeline fails. Defaults to `false`.
     */
    @JvmName("snqmmsugtuyoxevt")
    public suspend fun terminateInstanceOnFailure(`value`: Output<Boolean>) {
        this.terminateInstanceOnFailure = value
    }

    /**
     * @param value Description for the configuration.
     */
    @JvmName("erhkhssoaucpjkco")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Configuration block with instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances. Detailed below.
     */
    @JvmName("rylxxrmclboddrii")
    public suspend fun instanceMetadataOptions(`value`: InfrastructureConfigurationInstanceMetadataOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceMetadataOptions = mapped
    }

    /**
     * @param argument Configuration block with instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances. Detailed below.
     */
    @JvmName("pjdwfuagekgkitms")
    public suspend fun instanceMetadataOptions(argument: suspend InfrastructureConfigurationInstanceMetadataOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = InfrastructureConfigurationInstanceMetadataOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.instanceMetadataOptions = mapped
    }

    /**
     * @param value Name of IAM Instance Profile.
     */
    @JvmName("poktnluqfwlciqly")
    public suspend fun instanceProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceProfileName = mapped
    }

    /**
     * @param value Set of EC2 Instance Types.
     */
    @JvmName("uafveuagbiuohkox")
    public suspend fun instanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param values Set of EC2 Instance Types.
     */
    @JvmName("fpcsdrohyhqdoyuy")
    public suspend fun instanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceTypes = mapped
    }

    /**
     * @param value Name of EC2 Key Pair.
     */
    @JvmName("wgkphroobkloeuex")
    public suspend fun keyPair(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyPair = mapped
    }

    /**
     * @param value Configuration block with logging settings. Detailed below.
     */
    @JvmName("autffkpredyxqhja")
    public suspend fun logging(`value`: InfrastructureConfigurationLoggingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logging = mapped
    }

    /**
     * @param argument Configuration block with logging settings. Detailed below.
     */
    @JvmName("nigoorenqaxkjiak")
    public suspend fun logging(argument: suspend InfrastructureConfigurationLoggingArgsBuilder.() -> Unit) {
        val toBeMapped = InfrastructureConfigurationLoggingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.logging = mapped
    }

    /**
     * @param value Name for the configuration.
     * The following arguments are optional:
     */
    @JvmName("bloemylpdomguwqk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags to assign to infrastructure created by the configuration.
     */
    @JvmName("jcoclgbvpfphbkun")
    public suspend fun resourceTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param values Key-value map of resource tags to assign to infrastructure created by the configuration.
     */
    @JvmName("wjejtikybvrhjewi")
    public fun resourceTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param value Set of EC2 Security Group identifiers.
     */
    @JvmName("arfqishxsbjejnjt")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Set of EC2 Security Group identifiers.
     */
    @JvmName("hyrysvlasdeexwjl")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of SNS Topic.
     */
    @JvmName("germtwgspvfgnnqa")
    public suspend fun snsTopicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopicArn = mapped
    }

    /**
     * @param value EC2 Subnet identifier. Also requires `security_group_ids` argument.
     */
    @JvmName("swlhvydvolefxxsi")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Key-value map of resource tags to assign to the configuration. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ugprocyqnrxltkln")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags to assign to the configuration. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jvgpulvbawkyrccs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Enable if the instance should be terminated when the pipeline fails. Defaults to `false`.
     */
    @JvmName("kiyvtydiblatcshf")
    public suspend fun terminateInstanceOnFailure(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.terminateInstanceOnFailure = mapped
    }

    internal fun build(): InfrastructureConfigurationArgs = InfrastructureConfigurationArgs(
        description = description,
        instanceMetadataOptions = instanceMetadataOptions,
        instanceProfileName = instanceProfileName,
        instanceTypes = instanceTypes,
        keyPair = keyPair,
        logging = logging,
        name = name,
        resourceTags = resourceTags,
        securityGroupIds = securityGroupIds,
        snsTopicArn = snsTopicArn,
        subnetId = subnetId,
        tags = tags,
        terminateInstanceOnFailure = terminateInstanceOnFailure,
    )
}
