@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Workflow].
 */
@PulumiTagMarker
public class WorkflowResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkflowArgs = WorkflowArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkflowArgsBuilder.() -> Unit) {
        val builder = WorkflowArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Workflow {
        val builtJavaResource = com.pulumi.aws.imagebuilder.Workflow(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workflow(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS EC2 Image Builder Workflow.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.imagebuilder.Workflow("example", {
 *     name: "example",
 *     version: "1.0.0",
 *     type: "TEST",
 *     data: `name: example
 * description: Workflow to test an image
 * schemaVersion: 1.0
 * parameters:
 *   - name: waitForActionAtEnd
 *     type: boolean
 * steps:
 *   - name: LaunchTestInstance
 *     action: LaunchInstance
 *     onFailure: Abort
 *     inputs:
 *       waitFor: "ssmAgent"
 *   - name: TerminateTestInstance
 *     action: TerminateInstance
 *     onFailure: Continue
 *     inputs:
 *       instanceId.: ".stepOutputs.LaunchTestInstance.instanceId"
 *   - name: WaitForActionAtEnd
 *     action: WaitForAction
 *     if:
 *       booleanEquals: true
 *       value: ".parameters.waitForActionAtEnd"
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.imagebuilder.Workflow("example",
 *     name="example",
 *     version="1.0.0",
 *     type="TEST",
 *     data="""name: example
 * description: Workflow to test an image
 * schemaVersion: 1.0
 * parameters:
 *   - name: waitForActionAtEnd
 *     type: boolean
 * steps:
 *   - name: LaunchTestInstance
 *     action: LaunchInstance
 *     onFailure: Abort
 *     inputs:
 *       waitFor: "ssmAgent"
 *   - name: TerminateTestInstance
 *     action: TerminateInstance
 *     onFailure: Continue
 *     inputs:
 *       instanceId.$: "$.stepOutputs.LaunchTestInstance.instanceId"
 *   - name: WaitForActionAtEnd
 *     action: WaitForAction
 *     if:
 *       booleanEquals: true
 *       value: "$.parameters.waitForActionAtEnd"
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ImageBuilder.Workflow("example", new()
 *     {
 *         Name = "example",
 *         Version = "1.0.0",
 *         Type = "TEST",
 *         Data = @"name: example
 * description: Workflow to test an image
 * schemaVersion: 1.0
 * parameters:
 *   - name: waitForActionAtEnd
 *     type: boolean
 * steps:
 *   - name: LaunchTestInstance
 *     action: LaunchInstance
 *     onFailure: Abort
 *     inputs:
 *       waitFor: ""ssmAgent""
 *   - name: TerminateTestInstance
 *     action: TerminateInstance
 *     onFailure: Continue
 *     inputs:
 *       instanceId.$: ""$.stepOutputs.LaunchTestInstance.instanceId""
 *   - name: WaitForActionAtEnd
 *     action: WaitForAction
 *     if:
 *       booleanEquals: true
 *       value: ""$.parameters.waitForActionAtEnd""
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/imagebuilder"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := imagebuilder.NewWorkflow(ctx, "example", &imagebuilder.WorkflowArgs{
 * 			Name:    pulumi.String("example"),
 * 			Version: pulumi.String("1.0.0"),
 * 			Type:    pulumi.String("TEST"),
 * 			Data: pulumi.String(`name: example
 * description: Workflow to test an image
 * schemaVersion: 1.0
 * parameters:
 *   - name: waitForActionAtEnd
 *     type: boolean
 * steps:
 *   - name: LaunchTestInstance
 *     action: LaunchInstance
 *     onFailure: Abort
 *     inputs:
 *       waitFor: "ssmAgent"
 *   - name: TerminateTestInstance
 *     action: TerminateInstance
 *     onFailure: Continue
 *     inputs:
 *       instanceId.$: "$.stepOutputs.LaunchTestInstance.instanceId"
 *   - name: WaitForActionAtEnd
 *     action: WaitForAction
 *     if:
 *       booleanEquals: true
 *       value: "$.parameters.waitForActionAtEnd"
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.Workflow;
 * import com.pulumi.aws.imagebuilder.WorkflowArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workflow("example", WorkflowArgs.builder()
 *             .name("example")
 *             .version("1.0.0")
 *             .type("TEST")
 *             .data("""
 * name: example
 * description: Workflow to test an image
 * schemaVersion: 1.0
 * parameters:
 *   - name: waitForActionAtEnd
 *     type: boolean
 * steps:
 *   - name: LaunchTestInstance
 *     action: LaunchInstance
 *     onFailure: Abort
 *     inputs:
 *       waitFor: "ssmAgent"
 *   - name: TerminateTestInstance
 *     action: TerminateInstance
 *     onFailure: Continue
 *     inputs:
 *       instanceId.$: "$.stepOutputs.LaunchTestInstance.instanceId"
 *   - name: WaitForActionAtEnd
 *     action: WaitForAction
 *     if:
 *       booleanEquals: true
 *       value: "$.parameters.waitForActionAtEnd"
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:imagebuilder:Workflow
 *     properties:
 *       name: example
 *       version: 1.0.0
 *       type: TEST
 *       data: |
 *         name: example
 *         description: Workflow to test an image
 *         schemaVersion: 1.0
 *         parameters:
 *           - name: waitForActionAtEnd
 *             type: boolean
 *         steps:
 *           - name: LaunchTestInstance
 *             action: LaunchInstance
 *             onFailure: Abort
 *             inputs:
 *               waitFor: "ssmAgent"
 *           - name: TerminateTestInstance
 *             action: TerminateInstance
 *             onFailure: Continue
 *             inputs:
 *               instanceId.$: "$.stepOutputs.LaunchTestInstance.instanceId"
 *           - name: WaitForActionAtEnd
 *             action: WaitForAction
 *             if:
 *               booleanEquals: true
 *               value: "$.parameters.waitForActionAtEnd"
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EC2 Image Builder Workflow using the `example_id_arg`. For example:
 * ```sh
 * $ pulumi import aws:imagebuilder/workflow:Workflow example arn:aws:imagebuilder:us-east-1:aws:workflow/test/example/1.0.1/1
 * ```
 * Certain resource arguments, such as `uri`, cannot be read via the API and imported into Terraform. Terraform will display a difference for these arguments the first run after import if declared in the Terraform configuration for an imported resource.
 */
public class Workflow internal constructor(
    override val javaResource: com.pulumi.aws.imagebuilder.Workflow,
) : KotlinCustomResource(javaResource, WorkflowMapper) {
    /**
     * Amazon Resource Name (ARN) of the workflow.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Change description of the workflow.
     */
    public val changeDescription: Output<String>?
        get() = javaResource.changeDescription().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Inline YAML string with data of the workflow. Exactly one of `data` and `uri` can be specified.
     */
    public val `data`: Output<String>
        get() = javaResource.`data`().applyValue({ args0 -> args0 })

    /**
     * Date the workflow was created.
     */
    public val dateCreated: Output<String>
        get() = javaResource.dateCreated().applyValue({ args0 -> args0 })

    /**
     * Description of the workflow.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the Key Management Service (KMS) Key used to encrypt the workflow.
     */
    public val kmsKeyId: Output<String>?
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the workflow.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Owner of the workflow.
     */
    public val owner: Output<String>
        get() = javaResource.owner().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags for the workflow. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Type of the workflow. Valid values: `BUILD`, `TEST`, `DISTRIBUTION`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * S3 URI with data of the workflow. Exactly one of `data` and `uri` can be specified.
     */
    public val uri: Output<String>?
        get() = javaResource.uri().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Version of the workflow.
     * The following arguments are optional:
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object WorkflowMapper : ResourceMapper<Workflow> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.imagebuilder.Workflow::class == javaResource::class

    override fun map(javaResource: Resource): Workflow = Workflow(
        javaResource as
            com.pulumi.aws.imagebuilder.Workflow,
    )
}

/**
 * @see [Workflow].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workflow].
 */
public suspend fun workflow(name: String, block: suspend WorkflowResourceBuilder.() -> Unit): Workflow {
    val builder = WorkflowResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workflow].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workflow(name: String): Workflow {
    val builder = WorkflowResourceBuilder()
    builder.name(name)
    return builder.build()
}
