@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin

import com.pulumi.aws.imagebuilder.WorkflowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS EC2 Image Builder Workflow.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.imagebuilder.Workflow("example", {
 *     name: "example",
 *     version: "1.0.0",
 *     type: "TEST",
 *     data: `name: example
 * description: Workflow to test an image
 * schemaVersion: 1.0
 * parameters:
 *   - name: waitForActionAtEnd
 *     type: boolean
 * steps:
 *   - name: LaunchTestInstance
 *     action: LaunchInstance
 *     onFailure: Abort
 *     inputs:
 *       waitFor: "ssmAgent"
 *   - name: TerminateTestInstance
 *     action: TerminateInstance
 *     onFailure: Continue
 *     inputs:
 *       instanceId.: ".stepOutputs.LaunchTestInstance.instanceId"
 *   - name: WaitForActionAtEnd
 *     action: WaitForAction
 *     if:
 *       booleanEquals: true
 *       value: ".parameters.waitForActionAtEnd"
 * `,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.imagebuilder.Workflow("example",
 *     name="example",
 *     version="1.0.0",
 *     type="TEST",
 *     data="""name: example
 * description: Workflow to test an image
 * schemaVersion: 1.0
 * parameters:
 *   - name: waitForActionAtEnd
 *     type: boolean
 * steps:
 *   - name: LaunchTestInstance
 *     action: LaunchInstance
 *     onFailure: Abort
 *     inputs:
 *       waitFor: "ssmAgent"
 *   - name: TerminateTestInstance
 *     action: TerminateInstance
 *     onFailure: Continue
 *     inputs:
 *       instanceId.$: "$.stepOutputs.LaunchTestInstance.instanceId"
 *   - name: WaitForActionAtEnd
 *     action: WaitForAction
 *     if:
 *       booleanEquals: true
 *       value: "$.parameters.waitForActionAtEnd"
 * """)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.ImageBuilder.Workflow("example", new()
 *     {
 *         Name = "example",
 *         Version = "1.0.0",
 *         Type = "TEST",
 *         Data = @"name: example
 * description: Workflow to test an image
 * schemaVersion: 1.0
 * parameters:
 *   - name: waitForActionAtEnd
 *     type: boolean
 * steps:
 *   - name: LaunchTestInstance
 *     action: LaunchInstance
 *     onFailure: Abort
 *     inputs:
 *       waitFor: ""ssmAgent""
 *   - name: TerminateTestInstance
 *     action: TerminateInstance
 *     onFailure: Continue
 *     inputs:
 *       instanceId.$: ""$.stepOutputs.LaunchTestInstance.instanceId""
 *   - name: WaitForActionAtEnd
 *     action: WaitForAction
 *     if:
 *       booleanEquals: true
 *       value: ""$.parameters.waitForActionAtEnd""
 * ",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/imagebuilder"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := imagebuilder.NewWorkflow(ctx, "example", &imagebuilder.WorkflowArgs{
 * 			Name:    pulumi.String("example"),
 * 			Version: pulumi.String("1.0.0"),
 * 			Type:    pulumi.String("TEST"),
 * 			Data: pulumi.String(`name: example
 * description: Workflow to test an image
 * schemaVersion: 1.0
 * parameters:
 *   - name: waitForActionAtEnd
 *     type: boolean
 * steps:
 *   - name: LaunchTestInstance
 *     action: LaunchInstance
 *     onFailure: Abort
 *     inputs:
 *       waitFor: "ssmAgent"
 *   - name: TerminateTestInstance
 *     action: TerminateInstance
 *     onFailure: Continue
 *     inputs:
 *       instanceId.$: "$.stepOutputs.LaunchTestInstance.instanceId"
 *   - name: WaitForActionAtEnd
 *     action: WaitForAction
 *     if:
 *       booleanEquals: true
 *       value: "$.parameters.waitForActionAtEnd"
 * `),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.imagebuilder.Workflow;
 * import com.pulumi.aws.imagebuilder.WorkflowArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workflow("example", WorkflowArgs.builder()
 *             .name("example")
 *             .version("1.0.0")
 *             .type("TEST")
 *             .data("""
 * name: example
 * description: Workflow to test an image
 * schemaVersion: 1.0
 * parameters:
 *   - name: waitForActionAtEnd
 *     type: boolean
 * steps:
 *   - name: LaunchTestInstance
 *     action: LaunchInstance
 *     onFailure: Abort
 *     inputs:
 *       waitFor: "ssmAgent"
 *   - name: TerminateTestInstance
 *     action: TerminateInstance
 *     onFailure: Continue
 *     inputs:
 *       instanceId.$: "$.stepOutputs.LaunchTestInstance.instanceId"
 *   - name: WaitForActionAtEnd
 *     action: WaitForAction
 *     if:
 *       booleanEquals: true
 *       value: "$.parameters.waitForActionAtEnd"
 *             """)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:imagebuilder:Workflow
 *     properties:
 *       name: example
 *       version: 1.0.0
 *       type: TEST
 *       data: |
 *         name: example
 *         description: Workflow to test an image
 *         schemaVersion: 1.0
 *         parameters:
 *           - name: waitForActionAtEnd
 *             type: boolean
 *         steps:
 *           - name: LaunchTestInstance
 *             action: LaunchInstance
 *             onFailure: Abort
 *             inputs:
 *               waitFor: "ssmAgent"
 *           - name: TerminateTestInstance
 *             action: TerminateInstance
 *             onFailure: Continue
 *             inputs:
 *               instanceId.$: "$.stepOutputs.LaunchTestInstance.instanceId"
 *           - name: WaitForActionAtEnd
 *             action: WaitForAction
 *             if:
 *               booleanEquals: true
 *               value: "$.parameters.waitForActionAtEnd"
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EC2 Image Builder Workflow using the `example_id_arg`. For example:
 * ```sh
 * $ pulumi import aws:imagebuilder/workflow:Workflow example arn:aws:imagebuilder:us-east-1:aws:workflow/test/example/1.0.1/1
 * ```
 * Certain resource arguments, such as `uri`, cannot be read via the API and imported into Terraform. Terraform will display a difference for these arguments the first run after import if declared in the Terraform configuration for an imported resource.
 * @property changeDescription Change description of the workflow.
 * @property data Inline YAML string with data of the workflow. Exactly one of `data` and `uri` can be specified.
 * @property description Description of the workflow.
 * @property kmsKeyId Amazon Resource Name (ARN) of the Key Management Service (KMS) Key used to encrypt the workflow.
 * @property name Name of the workflow.
 * @property tags Key-value map of resource tags for the workflow. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type Type of the workflow. Valid values: `BUILD`, `TEST`, `DISTRIBUTION`.
 * @property uri S3 URI with data of the workflow. Exactly one of `data` and `uri` can be specified.
 * @property version Version of the workflow.
 * The following arguments are optional:
 */
public data class WorkflowArgs(
    public val changeDescription: Output<String>? = null,
    public val `data`: Output<String>? = null,
    public val description: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val uri: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.WorkflowArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.WorkflowArgs =
        com.pulumi.aws.imagebuilder.WorkflowArgs.builder()
            .changeDescription(changeDescription?.applyValue({ args0 -> args0 }))
            .`data`(`data`?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowArgs].
 */
@PulumiTagMarker
public class WorkflowArgsBuilder internal constructor() {
    private var changeDescription: Output<String>? = null

    private var `data`: Output<String>? = null

    private var description: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var uri: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Change description of the workflow.
     */
    @JvmName("uljrvcfxsnnthnds")
    public suspend fun changeDescription(`value`: Output<String>) {
        this.changeDescription = value
    }

    /**
     * @param value Inline YAML string with data of the workflow. Exactly one of `data` and `uri` can be specified.
     */
    @JvmName("kcwcskarxhfcpctm")
    public suspend fun `data`(`value`: Output<String>) {
        this.`data` = value
    }

    /**
     * @param value Description of the workflow.
     */
    @JvmName("bsrtsacbqndwbhii")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Key Management Service (KMS) Key used to encrypt the workflow.
     */
    @JvmName("lvtpgpaqjnqjwvsi")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Name of the workflow.
     */
    @JvmName("vcvfmvcnjcmaukme")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of resource tags for the workflow. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hnlsdlpbvirkudku")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Type of the workflow. Valid values: `BUILD`, `TEST`, `DISTRIBUTION`.
     */
    @JvmName("pblbigixvbiyluii")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value S3 URI with data of the workflow. Exactly one of `data` and `uri` can be specified.
     */
    @JvmName("jkpatipcjjecjbne")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Version of the workflow.
     * The following arguments are optional:
     */
    @JvmName("xetrnssthspusife")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Change description of the workflow.
     */
    @JvmName("fxhcaxhxyhdoeudj")
    public suspend fun changeDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.changeDescription = mapped
    }

    /**
     * @param value Inline YAML string with data of the workflow. Exactly one of `data` and `uri` can be specified.
     */
    @JvmName("klboubhwvyxdonke")
    public suspend fun `data`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`data` = mapped
    }

    /**
     * @param value Description of the workflow.
     */
    @JvmName("lqgjoskmjodntvde")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Key Management Service (KMS) Key used to encrypt the workflow.
     */
    @JvmName("ujrwuvsgqikiceqd")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Name of the workflow.
     */
    @JvmName("wpkcxfatpelounfl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of resource tags for the workflow. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("plcibtpcpvilwsor")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the workflow. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iwpfshdcthtpknpl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Type of the workflow. Valid values: `BUILD`, `TEST`, `DISTRIBUTION`.
     */
    @JvmName("ujyaamabnquyuyjr")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value S3 URI with data of the workflow. Exactly one of `data` and `uri` can be specified.
     */
    @JvmName("uhcortyeakyudycl")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    /**
     * @param value Version of the workflow.
     * The following arguments are optional:
     */
    @JvmName("ewterwlidcsproog")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): WorkflowArgs = WorkflowArgs(
        changeDescription = changeDescription,
        `data` = `data`,
        description = description,
        kmsKeyId = kmsKeyId,
        name = name,
        tags = tags,
        type = type,
        uri = uri,
        version = version,
    )
}
