@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeInstanceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property blockDeviceMappings Configuration block(s) with block device mappings for the container recipe. Detailed below.
 * @property image The AMI ID to use as the base image for a container build and test instance. If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
 */
public data class ContainerRecipeInstanceConfigurationArgs(
    public val blockDeviceMappings: Output<List<ContainerRecipeInstanceConfigurationBlockDeviceMappingArgs>>? = null,
    public val image: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ContainerRecipeInstanceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ContainerRecipeInstanceConfigurationArgs = com.pulumi.aws.imagebuilder.inputs.ContainerRecipeInstanceConfigurationArgs.builder()
        .blockDeviceMappings(
            blockDeviceMappings?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .image(image?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerRecipeInstanceConfigurationArgs].
 */
@PulumiTagMarker
public class ContainerRecipeInstanceConfigurationArgsBuilder internal constructor() {
    private var blockDeviceMappings:
        Output<List<ContainerRecipeInstanceConfigurationBlockDeviceMappingArgs>>? = null

    private var image: Output<String>? = null

    /**
     * @param value Configuration block(s) with block device mappings for the container recipe. Detailed below.
     */
    @JvmName("okyryxmgqltnabxa")
    public suspend fun blockDeviceMappings(`value`: Output<List<ContainerRecipeInstanceConfigurationBlockDeviceMappingArgs>>) {
        this.blockDeviceMappings = value
    }

    @JvmName("fstdhhobwmcphbsb")
    public suspend fun blockDeviceMappings(vararg values: Output<ContainerRecipeInstanceConfigurationBlockDeviceMappingArgs>) {
        this.blockDeviceMappings = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) with block device mappings for the container recipe. Detailed below.
     */
    @JvmName("dhuogxjdrqauxiip")
    public suspend fun blockDeviceMappings(values: List<Output<ContainerRecipeInstanceConfigurationBlockDeviceMappingArgs>>) {
        this.blockDeviceMappings = Output.all(values)
    }

    /**
     * @param value The AMI ID to use as the base image for a container build and test instance. If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
     */
    @JvmName("pgdmewqwchnenskg")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Configuration block(s) with block device mappings for the container recipe. Detailed below.
     */
    @JvmName("fgiobammdxncpdvq")
    public suspend fun blockDeviceMappings(`value`: List<ContainerRecipeInstanceConfigurationBlockDeviceMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blockDeviceMappings = mapped
    }

    /**
     * @param argument Configuration block(s) with block device mappings for the container recipe. Detailed below.
     */
    @JvmName("ehdknykkhpevvgvj")
    public suspend fun blockDeviceMappings(argument: List<suspend ContainerRecipeInstanceConfigurationBlockDeviceMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ContainerRecipeInstanceConfigurationBlockDeviceMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.blockDeviceMappings = mapped
    }

    /**
     * @param argument Configuration block(s) with block device mappings for the container recipe. Detailed below.
     */
    @JvmName("hkwbfdlwiffcedwf")
    public suspend fun blockDeviceMappings(vararg argument: suspend ContainerRecipeInstanceConfigurationBlockDeviceMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ContainerRecipeInstanceConfigurationBlockDeviceMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.blockDeviceMappings = mapped
    }

    /**
     * @param argument Configuration block(s) with block device mappings for the container recipe. Detailed below.
     */
    @JvmName("injmlvawvltrcluy")
    public suspend fun blockDeviceMappings(argument: suspend ContainerRecipeInstanceConfigurationBlockDeviceMappingArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ContainerRecipeInstanceConfigurationBlockDeviceMappingArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.blockDeviceMappings = mapped
    }

    /**
     * @param values Configuration block(s) with block device mappings for the container recipe. Detailed below.
     */
    @JvmName("lwkkfcnccrmwxqch")
    public suspend fun blockDeviceMappings(vararg values: ContainerRecipeInstanceConfigurationBlockDeviceMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blockDeviceMappings = mapped
    }

    /**
     * @param value The AMI ID to use as the base image for a container build and test instance. If not specified, Image Builder will use the appropriate ECS-optimized AMI as a base image.
     */
    @JvmName("ooddoyxqdnhmbrvw")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    internal fun build(): ContainerRecipeInstanceConfigurationArgs =
        ContainerRecipeInstanceConfigurationArgs(
            blockDeviceMappings = blockDeviceMappings,
            image = image,
        )
}
