@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ContainerRecipeTargetRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property repositoryName The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
 * @property service The service in which this image is registered. Valid values: `ECR`.
 */
public data class ContainerRecipeTargetRepositoryArgs(
    public val repositoryName: Output<String>,
    public val service: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ContainerRecipeTargetRepositoryArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ContainerRecipeTargetRepositoryArgs =
        com.pulumi.aws.imagebuilder.inputs.ContainerRecipeTargetRepositoryArgs.builder()
            .repositoryName(repositoryName.applyValue({ args0 -> args0 }))
            .service(service.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ContainerRecipeTargetRepositoryArgs].
 */
@PulumiTagMarker
public class ContainerRecipeTargetRepositoryArgsBuilder internal constructor() {
    private var repositoryName: Output<String>? = null

    private var service: Output<String>? = null

    /**
     * @param value The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
     */
    @JvmName("gftsfhknhphqvckf")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value The service in which this image is registered. Valid values: `ECR`.
     */
    @JvmName("tkjktvibisefkbwv")
    public suspend fun service(`value`: Output<String>) {
        this.service = value
    }

    /**
     * @param value The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
     */
    @JvmName("bvitvumbgahotehs")
    public suspend fun repositoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    /**
     * @param value The service in which this image is registered. Valid values: `ECR`.
     */
    @JvmName("htnkpwjauqwnacfe")
    public suspend fun service(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.service = mapped
    }

    internal fun build(): ContainerRecipeTargetRepositoryArgs = ContainerRecipeTargetRepositoryArgs(
        repositoryName = repositoryName ?: throw PulumiNullFieldException("repositoryName"),
        service = service ?: throw PulumiNullFieldException("service"),
    )
}
