@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property amiDistributionConfiguration Configuration block with Amazon Machine Image (AMI) distribution settings. Detailed below.
 * @property containerDistributionConfiguration Configuration block with container distribution settings. Detailed below.
 * @property fastLaunchConfigurations Set of Windows faster-launching configurations to use for AMI distribution. Detailed below.
 * @property launchTemplateConfigurations Set of launch template configuration settings that apply to image distribution. Detailed below.
 * @property licenseConfigurationArns Set of Amazon Resource Names (ARNs) of License Manager License Configurations.
 * @property region AWS Region for the distribution.
 * The following arguments are optional:
 */
public data class DistributionConfigurationDistributionArgs(
    public val amiDistributionConfiguration: Output<DistributionConfigurationDistributionAmiDistributionConfigurationArgs>? = null,
    public val containerDistributionConfiguration: Output<DistributionConfigurationDistributionContainerDistributionConfigurationArgs>? = null,
    public val fastLaunchConfigurations: Output<List<DistributionConfigurationDistributionFastLaunchConfigurationArgs>>? = null,
    public val launchTemplateConfigurations: Output<List<DistributionConfigurationDistributionLaunchTemplateConfigurationArgs>>? = null,
    public val licenseConfigurationArns: Output<List<String>>? = null,
    public val region: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionArgs =
        com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionArgs.builder()
            .amiDistributionConfiguration(
                amiDistributionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .containerDistributionConfiguration(
                containerDistributionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .fastLaunchConfigurations(
                fastLaunchConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .launchTemplateConfigurations(
                launchTemplateConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .licenseConfigurationArns(
                licenseConfigurationArns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .region(region.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionConfigurationDistributionArgs].
 */
@PulumiTagMarker
public class DistributionConfigurationDistributionArgsBuilder internal constructor() {
    private var amiDistributionConfiguration:
        Output<DistributionConfigurationDistributionAmiDistributionConfigurationArgs>? = null

    private var containerDistributionConfiguration:
        Output<DistributionConfigurationDistributionContainerDistributionConfigurationArgs>? = null

    private var fastLaunchConfigurations:
        Output<List<DistributionConfigurationDistributionFastLaunchConfigurationArgs>>? = null

    private var launchTemplateConfigurations:
        Output<List<DistributionConfigurationDistributionLaunchTemplateConfigurationArgs>>? = null

    private var licenseConfigurationArns: Output<List<String>>? = null

    private var region: Output<String>? = null

    /**
     * @param value Configuration block with Amazon Machine Image (AMI) distribution settings. Detailed below.
     */
    @JvmName("bikrauwqifuhnynp")
    public suspend fun amiDistributionConfiguration(`value`: Output<DistributionConfigurationDistributionAmiDistributionConfigurationArgs>) {
        this.amiDistributionConfiguration = value
    }

    /**
     * @param value Configuration block with container distribution settings. Detailed below.
     */
    @JvmName("bsfobdwalephqoxq")
    public suspend fun containerDistributionConfiguration(`value`: Output<DistributionConfigurationDistributionContainerDistributionConfigurationArgs>) {
        this.containerDistributionConfiguration = value
    }

    /**
     * @param value Set of Windows faster-launching configurations to use for AMI distribution. Detailed below.
     */
    @JvmName("oilbvehmokuejfsn")
    public suspend fun fastLaunchConfigurations(`value`: Output<List<DistributionConfigurationDistributionFastLaunchConfigurationArgs>>) {
        this.fastLaunchConfigurations = value
    }

    @JvmName("vmxnexlumspnkcgm")
    public suspend fun fastLaunchConfigurations(vararg values: Output<DistributionConfigurationDistributionFastLaunchConfigurationArgs>) {
        this.fastLaunchConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Set of Windows faster-launching configurations to use for AMI distribution. Detailed below.
     */
    @JvmName("rqudltkmtglfpcqo")
    public suspend fun fastLaunchConfigurations(values: List<Output<DistributionConfigurationDistributionFastLaunchConfigurationArgs>>) {
        this.fastLaunchConfigurations = Output.all(values)
    }

    /**
     * @param value Set of launch template configuration settings that apply to image distribution. Detailed below.
     */
    @JvmName("edpjiguhhssecjqe")
    public suspend fun launchTemplateConfigurations(`value`: Output<List<DistributionConfigurationDistributionLaunchTemplateConfigurationArgs>>) {
        this.launchTemplateConfigurations = value
    }

    @JvmName("wbpykatmessfkuhb")
    public suspend fun launchTemplateConfigurations(vararg values: Output<DistributionConfigurationDistributionLaunchTemplateConfigurationArgs>) {
        this.launchTemplateConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Set of launch template configuration settings that apply to image distribution. Detailed below.
     */
    @JvmName("efkylgytjjytbmbf")
    public suspend fun launchTemplateConfigurations(values: List<Output<DistributionConfigurationDistributionLaunchTemplateConfigurationArgs>>) {
        this.launchTemplateConfigurations = Output.all(values)
    }

    /**
     * @param value Set of Amazon Resource Names (ARNs) of License Manager License Configurations.
     */
    @JvmName("ivufuhyetsmkjclr")
    public suspend fun licenseConfigurationArns(`value`: Output<List<String>>) {
        this.licenseConfigurationArns = value
    }

    @JvmName("ocpyqywmxljbqypp")
    public suspend fun licenseConfigurationArns(vararg values: Output<String>) {
        this.licenseConfigurationArns = Output.all(values.asList())
    }

    /**
     * @param values Set of Amazon Resource Names (ARNs) of License Manager License Configurations.
     */
    @JvmName("xhrtiojfryosjkrw")
    public suspend fun licenseConfigurationArns(values: List<Output<String>>) {
        this.licenseConfigurationArns = Output.all(values)
    }

    /**
     * @param value AWS Region for the distribution.
     * The following arguments are optional:
     */
    @JvmName("pbajkqkiqbbtgkje")
    public suspend fun region(`value`: Output<String>) {
        this.region = value
    }

    /**
     * @param value Configuration block with Amazon Machine Image (AMI) distribution settings. Detailed below.
     */
    @JvmName("yxvhripgibllgljg")
    public suspend fun amiDistributionConfiguration(`value`: DistributionConfigurationDistributionAmiDistributionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amiDistributionConfiguration = mapped
    }

    /**
     * @param argument Configuration block with Amazon Machine Image (AMI) distribution settings. Detailed below.
     */
    @JvmName("ngoworrrvchlwkdt")
    public suspend fun amiDistributionConfiguration(argument: suspend DistributionConfigurationDistributionAmiDistributionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DistributionConfigurationDistributionAmiDistributionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.amiDistributionConfiguration = mapped
    }

    /**
     * @param value Configuration block with container distribution settings. Detailed below.
     */
    @JvmName("hkphtactqsbfrsan")
    public suspend fun containerDistributionConfiguration(`value`: DistributionConfigurationDistributionContainerDistributionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerDistributionConfiguration = mapped
    }

    /**
     * @param argument Configuration block with container distribution settings. Detailed below.
     */
    @JvmName("ultgjlkoyxlnmmik")
    public suspend fun containerDistributionConfiguration(argument: suspend DistributionConfigurationDistributionContainerDistributionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DistributionConfigurationDistributionContainerDistributionConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.containerDistributionConfiguration = mapped
    }

    /**
     * @param value Set of Windows faster-launching configurations to use for AMI distribution. Detailed below.
     */
    @JvmName("ebdnxifkvuxewkee")
    public suspend fun fastLaunchConfigurations(`value`: List<DistributionConfigurationDistributionFastLaunchConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fastLaunchConfigurations = mapped
    }

    /**
     * @param argument Set of Windows faster-launching configurations to use for AMI distribution. Detailed below.
     */
    @JvmName("xrsrcagfochiydyf")
    public suspend fun fastLaunchConfigurations(argument: List<suspend DistributionConfigurationDistributionFastLaunchConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionConfigurationDistributionFastLaunchConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fastLaunchConfigurations = mapped
    }

    /**
     * @param argument Set of Windows faster-launching configurations to use for AMI distribution. Detailed below.
     */
    @JvmName("ohchcgtdkeiljypg")
    public suspend fun fastLaunchConfigurations(vararg argument: suspend DistributionConfigurationDistributionFastLaunchConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DistributionConfigurationDistributionFastLaunchConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fastLaunchConfigurations = mapped
    }

    /**
     * @param argument Set of Windows faster-launching configurations to use for AMI distribution. Detailed below.
     */
    @JvmName("utcmllidtwikmlod")
    public suspend fun fastLaunchConfigurations(argument: suspend DistributionConfigurationDistributionFastLaunchConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DistributionConfigurationDistributionFastLaunchConfigurationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.fastLaunchConfigurations = mapped
    }

    /**
     * @param values Set of Windows faster-launching configurations to use for AMI distribution. Detailed below.
     */
    @JvmName("xrpyuiynoqyeyqam")
    public suspend fun fastLaunchConfigurations(vararg values: DistributionConfigurationDistributionFastLaunchConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fastLaunchConfigurations = mapped
    }

    /**
     * @param value Set of launch template configuration settings that apply to image distribution. Detailed below.
     */
    @JvmName("jtppmhxvmjfoyxry")
    public suspend fun launchTemplateConfigurations(`value`: List<DistributionConfigurationDistributionLaunchTemplateConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateConfigurations = mapped
    }

    /**
     * @param argument Set of launch template configuration settings that apply to image distribution. Detailed below.
     */
    @JvmName("thponxuhxdptywqy")
    public suspend fun launchTemplateConfigurations(argument: List<suspend DistributionConfigurationDistributionLaunchTemplateConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DistributionConfigurationDistributionLaunchTemplateConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.launchTemplateConfigurations = mapped
    }

    /**
     * @param argument Set of launch template configuration settings that apply to image distribution. Detailed below.
     */
    @JvmName("bnrybwkctlljxgvf")
    public suspend fun launchTemplateConfigurations(vararg argument: suspend DistributionConfigurationDistributionLaunchTemplateConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DistributionConfigurationDistributionLaunchTemplateConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.launchTemplateConfigurations = mapped
    }

    /**
     * @param argument Set of launch template configuration settings that apply to image distribution. Detailed below.
     */
    @JvmName("rwvgvybwrbsmxjki")
    public suspend fun launchTemplateConfigurations(argument: suspend DistributionConfigurationDistributionLaunchTemplateConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DistributionConfigurationDistributionLaunchTemplateConfigurationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.launchTemplateConfigurations = mapped
    }

    /**
     * @param values Set of launch template configuration settings that apply to image distribution. Detailed below.
     */
    @JvmName("jspclowwfntrieun")
    public suspend fun launchTemplateConfigurations(vararg values: DistributionConfigurationDistributionLaunchTemplateConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.launchTemplateConfigurations = mapped
    }

    /**
     * @param value Set of Amazon Resource Names (ARNs) of License Manager License Configurations.
     */
    @JvmName("retpsjdvhrvcpfll")
    public suspend fun licenseConfigurationArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseConfigurationArns = mapped
    }

    /**
     * @param values Set of Amazon Resource Names (ARNs) of License Manager License Configurations.
     */
    @JvmName("kupwwxkubfsnrqqy")
    public suspend fun licenseConfigurationArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseConfigurationArns = mapped
    }

    /**
     * @param value AWS Region for the distribution.
     * The following arguments are optional:
     */
    @JvmName("jakqedewyqmxunjd")
    public suspend fun region(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.region = mapped
    }

    internal fun build(): DistributionConfigurationDistributionArgs =
        DistributionConfigurationDistributionArgs(
            amiDistributionConfiguration = amiDistributionConfiguration,
            containerDistributionConfiguration = containerDistributionConfiguration,
            fastLaunchConfigurations = fastLaunchConfigurations,
            launchTemplateConfigurations = launchTemplateConfigurations,
            licenseConfigurationArns = licenseConfigurationArns,
            region = region ?: throw PulumiNullFieldException("region"),
        )
}
