@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionContainerDistributionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property containerTags Set of tags that are attached to the container distribution configuration.
 * @property description Description of the container distribution configuration.
 * @property targetRepository Configuration block with the destination repository for the container distribution configuration.
 */
public data class DistributionConfigurationDistributionContainerDistributionConfigurationArgs(
    public val containerTags: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val targetRepository: Output<DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepositoryArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionContainerDistributionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionContainerDistributionConfigurationArgs =
        com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionContainerDistributionConfigurationArgs.builder()
            .containerTags(containerTags?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .targetRepository(
                targetRepository.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DistributionConfigurationDistributionContainerDistributionConfigurationArgs].
 */
@PulumiTagMarker
public class DistributionConfigurationDistributionContainerDistributionConfigurationArgsBuilder
internal constructor() {
    private var containerTags: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var targetRepository:
        Output<DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepositoryArgs>? =
        null

    /**
     * @param value Set of tags that are attached to the container distribution configuration.
     */
    @JvmName("avjfvddgwqyenoex")
    public suspend fun containerTags(`value`: Output<List<String>>) {
        this.containerTags = value
    }

    @JvmName("wjspfyxgsuipefqe")
    public suspend fun containerTags(vararg values: Output<String>) {
        this.containerTags = Output.all(values.asList())
    }

    /**
     * @param values Set of tags that are attached to the container distribution configuration.
     */
    @JvmName("eogrvwxmbjwvgnuv")
    public suspend fun containerTags(values: List<Output<String>>) {
        this.containerTags = Output.all(values)
    }

    /**
     * @param value Description of the container distribution configuration.
     */
    @JvmName("gohybgifdrtkpckc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Configuration block with the destination repository for the container distribution configuration.
     */
    @JvmName("onjwhamqtduqblcu")
    public suspend fun targetRepository(`value`: Output<DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepositoryArgs>) {
        this.targetRepository = value
    }

    /**
     * @param value Set of tags that are attached to the container distribution configuration.
     */
    @JvmName("ysrnfhwcrcicreew")
    public suspend fun containerTags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerTags = mapped
    }

    /**
     * @param values Set of tags that are attached to the container distribution configuration.
     */
    @JvmName("txdmbjgwuvulhtpp")
    public suspend fun containerTags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerTags = mapped
    }

    /**
     * @param value Description of the container distribution configuration.
     */
    @JvmName("anyutnigjmiwqmjc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Configuration block with the destination repository for the container distribution configuration.
     */
    @JvmName("byqfcmoileburvtm")
    public suspend fun targetRepository(`value`: DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepositoryArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetRepository = mapped
    }

    /**
     * @param argument Configuration block with the destination repository for the container distribution configuration.
     */
    @JvmName("itqvmmjkrmlrrlyh")
    public suspend fun targetRepository(argument: suspend DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped =
            DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepositoryArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.targetRepository = mapped
    }

    internal fun build(): DistributionConfigurationDistributionContainerDistributionConfigurationArgs = DistributionConfigurationDistributionContainerDistributionConfigurationArgs(
        containerTags = containerTags,
        description = description,
        targetRepository = targetRepository ?: throw PulumiNullFieldException("targetRepository"),
    )
}
