@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionFastLaunchConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accountId The owner account ID for the fast-launch enabled Windows AMI.
 * @property enabled A Boolean that represents the current state of faster launching for the Windows AMI. Set to `true` to start using Windows faster launching, or `false` to stop using it.
 * @property launchTemplate Configuration block for the launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots. Detailed below.
 * @property maxParallelLaunches The maximum number of parallel instances that are launched for creating resources.
 * @property snapshotConfiguration Configuration block for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled. Detailed below.
 */
public data class DistributionConfigurationDistributionFastLaunchConfigurationArgs(
    public val accountId: Output<String>,
    public val enabled: Output<Boolean>,
    public val launchTemplate: Output<DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs>? =
        null,
    public val maxParallelLaunches: Output<Int>? = null,
    public val snapshotConfiguration: Output<DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionFastLaunchConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionFastLaunchConfigurationArgs =
        com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionFastLaunchConfigurationArgs.builder()
            .accountId(accountId.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .launchTemplate(launchTemplate?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxParallelLaunches(maxParallelLaunches?.applyValue({ args0 -> args0 }))
            .snapshotConfiguration(
                snapshotConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DistributionConfigurationDistributionFastLaunchConfigurationArgs].
 */
@PulumiTagMarker
public class DistributionConfigurationDistributionFastLaunchConfigurationArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var launchTemplate:
        Output<DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs>? = null

    private var maxParallelLaunches: Output<Int>? = null

    private var snapshotConfiguration:
        Output<DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs>? =
        null

    /**
     * @param value The owner account ID for the fast-launch enabled Windows AMI.
     */
    @JvmName("wnykjkobtbammdfu")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value A Boolean that represents the current state of faster launching for the Windows AMI. Set to `true` to start using Windows faster launching, or `false` to stop using it.
     */
    @JvmName("tdukpkaaungbuatg")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Configuration block for the launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots. Detailed below.
     */
    @JvmName("khpwnpmrndqnmysw")
    public suspend fun launchTemplate(`value`: Output<DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs>) {
        this.launchTemplate = value
    }

    /**
     * @param value The maximum number of parallel instances that are launched for creating resources.
     */
    @JvmName("frncguhifmdgpkbq")
    public suspend fun maxParallelLaunches(`value`: Output<Int>) {
        this.maxParallelLaunches = value
    }

    /**
     * @param value Configuration block for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled. Detailed below.
     */
    @JvmName("txguyiexvnqqaxcn")
    public suspend fun snapshotConfiguration(`value`: Output<DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs>) {
        this.snapshotConfiguration = value
    }

    /**
     * @param value The owner account ID for the fast-launch enabled Windows AMI.
     */
    @JvmName("qqwycuppxkflkyio")
    public suspend fun accountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value A Boolean that represents the current state of faster launching for the Windows AMI. Set to `true` to start using Windows faster launching, or `false` to stop using it.
     */
    @JvmName("cpsldrnybrjfsiuy")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Configuration block for the launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots. Detailed below.
     */
    @JvmName("babhodaimhqewyxt")
    public suspend fun launchTemplate(`value`: DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplate = mapped
    }

    /**
     * @param argument Configuration block for the launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots. Detailed below.
     */
    @JvmName("amdovhekahbuhppk")
    public suspend fun launchTemplate(argument: suspend DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgsBuilder.() -> Unit) {
        val toBeMapped =
            DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.launchTemplate = mapped
    }

    /**
     * @param value The maximum number of parallel instances that are launched for creating resources.
     */
    @JvmName("mmbfwaaeafeahwtg")
    public suspend fun maxParallelLaunches(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxParallelLaunches = mapped
    }

    /**
     * @param value Configuration block for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled. Detailed below.
     */
    @JvmName("yosvsxfvgibrfemr")
    public suspend fun snapshotConfiguration(`value`: DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotConfiguration = mapped
    }

    /**
     * @param argument Configuration block for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled. Detailed below.
     */
    @JvmName("leihhhxeqtafarhj")
    public suspend fun snapshotConfiguration(argument: suspend DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.snapshotConfiguration = mapped
    }

    internal fun build(): DistributionConfigurationDistributionFastLaunchConfigurationArgs =
        DistributionConfigurationDistributionFastLaunchConfigurationArgs(
            accountId = accountId ?: throw PulumiNullFieldException("accountId"),
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            launchTemplate = launchTemplate,
            maxParallelLaunches = maxParallelLaunches,
            snapshotConfiguration = snapshotConfiguration,
        )
}
