@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property launchTemplateId The ID of the launch template to use for faster launching for a Windows AMI.
 * @property launchTemplateName The name of the launch template to use for faster launching for a Windows AMI.
 * @property launchTemplateVersion The version of the launch template to use for faster launching for a Windows AMI.
 */
public data class DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs(
    public val launchTemplateId: Output<String>? = null,
    public val launchTemplateName: Output<String>? = null,
    public val launchTemplateVersion: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs =
        com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs.builder()
            .launchTemplateId(launchTemplateId?.applyValue({ args0 -> args0 }))
            .launchTemplateName(launchTemplateName?.applyValue({ args0 -> args0 }))
            .launchTemplateVersion(launchTemplateVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs].
 */
@PulumiTagMarker
public class DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgsBuilder
internal constructor() {
    private var launchTemplateId: Output<String>? = null

    private var launchTemplateName: Output<String>? = null

    private var launchTemplateVersion: Output<String>? = null

    /**
     * @param value The ID of the launch template to use for faster launching for a Windows AMI.
     */
    @JvmName("ofldnhetqsbpoesx")
    public suspend fun launchTemplateId(`value`: Output<String>) {
        this.launchTemplateId = value
    }

    /**
     * @param value The name of the launch template to use for faster launching for a Windows AMI.
     */
    @JvmName("uutswwlnjxpqmxiq")
    public suspend fun launchTemplateName(`value`: Output<String>) {
        this.launchTemplateName = value
    }

    /**
     * @param value The version of the launch template to use for faster launching for a Windows AMI.
     */
    @JvmName("iitqjlacnguhjevg")
    public suspend fun launchTemplateVersion(`value`: Output<String>) {
        this.launchTemplateVersion = value
    }

    /**
     * @param value The ID of the launch template to use for faster launching for a Windows AMI.
     */
    @JvmName("fmpiayvsrejpxjgx")
    public suspend fun launchTemplateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateId = mapped
    }

    /**
     * @param value The name of the launch template to use for faster launching for a Windows AMI.
     */
    @JvmName("sujcunolstfgxkvl")
    public suspend fun launchTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateName = mapped
    }

    /**
     * @param value The version of the launch template to use for faster launching for a Windows AMI.
     */
    @JvmName("tschnhupbeooulin")
    public suspend fun launchTemplateVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.launchTemplateVersion = mapped
    }

    internal fun build(): DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs =
        DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplateArgs(
            launchTemplateId = launchTemplateId,
            launchTemplateName = launchTemplateName,
            launchTemplateVersion = launchTemplateVersion,
        )
}
