@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property targetResourceCount The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.
 */
public data class
DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs(
    public val targetResourceCount: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs =
        com.pulumi.aws.imagebuilder.inputs.DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs.builder()
            .targetResourceCount(targetResourceCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs].
 */
@PulumiTagMarker
public class
DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgsBuilder
internal constructor() {
    private var targetResourceCount: Output<Int>? = null

    /**
     * @param value The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.
     */
    @JvmName("xyvqcomhqdtlfhkp")
    public suspend fun targetResourceCount(`value`: Output<Int>) {
        this.targetResourceCount = value
    }

    /**
     * @param value The number of pre-provisioned snapshots to keep on hand for a fast-launch enabled Windows AMI.
     */
    @JvmName("ctbshgfssayaepur")
    public suspend fun targetResourceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceCount = mapped
    }

    internal fun build(): DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs =
        DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfigurationArgs(
            targetResourceCount = targetResourceCount,
        )
}
