@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.GetContainerRecipesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getContainerRecipes.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property owner Owner of the container recipes. Valid values are `Self`, `Shared`, `Amazon` and `ThirdParty`. Defaults to `Self`.
 */
public data class GetContainerRecipesPlainArgs(
    public val filters: List<GetContainerRecipesFilter>? = null,
    public val owner: String? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.GetContainerRecipesPlainArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.GetContainerRecipesPlainArgs =
        com.pulumi.aws.imagebuilder.inputs.GetContainerRecipesPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .owner(owner?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetContainerRecipesPlainArgs].
 */
@PulumiTagMarker
public class GetContainerRecipesPlainArgsBuilder internal constructor() {
    private var filters: List<GetContainerRecipesFilter>? = null

    private var owner: String? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("jeqtwyhmaxpaianq")
    public suspend fun filters(`value`: List<GetContainerRecipesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("jfqoyphgosnrdoqb")
    public suspend fun filters(argument: List<suspend GetContainerRecipesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetContainerRecipesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("skrlkxjatsytfvno")
    public suspend fun filters(vararg argument: suspend GetContainerRecipesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetContainerRecipesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("yqhjrwpslgwsmmuq")
    public suspend fun filters(argument: suspend GetContainerRecipesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetContainerRecipesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("afblvbjrtnirkcpi")
    public suspend fun filters(vararg values: GetContainerRecipesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Owner of the container recipes. Valid values are `Self`, `Shared`, `Amazon` and `ThirdParty`. Defaults to `Self`.
     */
    @JvmName("xpeiryynhxfympsa")
    public suspend fun owner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.owner = mapped
    }

    internal fun build(): GetContainerRecipesPlainArgs = GetContainerRecipesPlainArgs(
        filters = filters,
        owner = owner,
    )
}
