@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.GetImagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getImage.
 * @property arn ARN of the image. The suffix can either be specified with wildcards (`x.x.x`) to fetch the latest build version or a full build version (e.g., `2020.11.26/1`) to fetch an exact version.
 * @property tags Key-value map of resource tags for the image.
 */
public data class GetImagePlainArgs(
    public val arn: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.GetImagePlainArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.GetImagePlainArgs =
        com.pulumi.aws.imagebuilder.inputs.GetImagePlainArgs.builder()
            .arn(arn.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetImagePlainArgs].
 */
@PulumiTagMarker
public class GetImagePlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the image. The suffix can either be specified with wildcards (`x.x.x`) to fetch the latest build version or a full build version (e.g., `2020.11.26/1`) to fetch an exact version.
     */
    @JvmName("lhcnvcphhebrbiaj")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Key-value map of resource tags for the image.
     */
    @JvmName("pjlnipkaictskfhr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the image.
     */
    @JvmName("amhkodfyrfjjgpiq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetImagePlainArgs = GetImagePlainArgs(
        arn = arn ?: throw PulumiNullFieldException("arn"),
        tags = tags,
    )
}
