@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.GetImageRecipesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getImageRecipes.
 * @property filters Configuration block(s) for filtering. Detailed below.
 * @property owner Owner of the image recipes. Valid values are `Self`, `Shared`, `Amazon` and `ThirdParty`. Defaults to `Self`.
 */
public data class GetImageRecipesPlainArgs(
    public val filters: List<GetImageRecipesFilter>? = null,
    public val owner: String? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.GetImageRecipesPlainArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.GetImageRecipesPlainArgs =
        com.pulumi.aws.imagebuilder.inputs.GetImageRecipesPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .owner(owner?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImageRecipesPlainArgs].
 */
@PulumiTagMarker
public class GetImageRecipesPlainArgsBuilder internal constructor() {
    private var filters: List<GetImageRecipesFilter>? = null

    private var owner: String? = null

    /**
     * @param value Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("uibqqtahuuspraao")
    public suspend fun filters(`value`: List<GetImageRecipesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("jygllqaupcaifvjt")
    public suspend fun filters(argument: List<suspend GetImageRecipesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetImageRecipesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("wbeswftdahptsynd")
    public suspend fun filters(vararg argument: suspend GetImageRecipesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetImageRecipesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("gycqtwkutwvwntqk")
    public suspend fun filters(argument: suspend GetImageRecipesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetImageRecipesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) for filtering. Detailed below.
     */
    @JvmName("octpmbbggfwuwvhp")
    public suspend fun filters(vararg values: GetImageRecipesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Owner of the image recipes. Valid values are `Self`, `Shared`, `Amazon` and `ThirdParty`. Defaults to `Self`.
     */
    @JvmName("ugoecvkktuxacblv")
    public suspend fun owner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.owner = mapped
    }

    internal fun build(): GetImageRecipesPlainArgs = GetImageRecipesPlainArgs(
        filters = filters,
        owner = owner,
    )
}
