@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.GetInfrastructureConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInfrastructureConfiguration.
 * @property arn ARN of the infrastructure configuration.
 * @property resourceTags Key-value map of resource tags for the infrastructure created by the infrastructure configuration.
 * @property tags Key-value map of resource tags for the infrastructure configuration.
 */
public data class GetInfrastructureConfigurationPlainArgs(
    public val arn: String,
    public val resourceTags: Map<String, String>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.GetInfrastructureConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.GetInfrastructureConfigurationPlainArgs = com.pulumi.aws.imagebuilder.inputs.GetInfrastructureConfigurationPlainArgs.builder()
        .arn(arn.let({ args0 -> args0 }))
        .resourceTags(
            resourceTags?.let({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetInfrastructureConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetInfrastructureConfigurationPlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var resourceTags: Map<String, String>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value ARN of the infrastructure configuration.
     */
    @JvmName("nqtyeghjvcxmiecc")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Key-value map of resource tags for the infrastructure created by the infrastructure configuration.
     */
    @JvmName("njyrtyedpptitovb")
    public suspend fun resourceTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceTags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the infrastructure created by the infrastructure configuration.
     */
    @JvmName("qwvjvvpsyrhpojfk")
    public fun resourceTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceTags = mapped
    }

    /**
     * @param value Key-value map of resource tags for the infrastructure configuration.
     */
    @JvmName("qwenwugmrgigntuy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the infrastructure configuration.
     */
    @JvmName("gyaiygaxnfpbhxup")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetInfrastructureConfigurationPlainArgs =
        GetInfrastructureConfigurationPlainArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            resourceTags = resourceTags,
            tags = tags,
        )
}
