@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImageImageScanningConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property ecrConfiguration Configuration block with ECR configuration. Detailed below.
 * @property imageScanningEnabled Indicates whether Image Builder keeps a snapshot of the vulnerability scans that Amazon Inspector runs against the build instance when you create a new image. Defaults to `false`.
 */
public data class ImageImageScanningConfigurationArgs(
    public val ecrConfiguration: Output<ImageImageScanningConfigurationEcrConfigurationArgs>? = null,
    public val imageScanningEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImageImageScanningConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ImageImageScanningConfigurationArgs =
        com.pulumi.aws.imagebuilder.inputs.ImageImageScanningConfigurationArgs.builder()
            .ecrConfiguration(ecrConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageScanningEnabled(imageScanningEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageImageScanningConfigurationArgs].
 */
@PulumiTagMarker
public class ImageImageScanningConfigurationArgsBuilder internal constructor() {
    private var ecrConfiguration: Output<ImageImageScanningConfigurationEcrConfigurationArgs>? = null

    private var imageScanningEnabled: Output<Boolean>? = null

    /**
     * @param value Configuration block with ECR configuration. Detailed below.
     */
    @JvmName("dyvslqridbanpqyp")
    public suspend fun ecrConfiguration(`value`: Output<ImageImageScanningConfigurationEcrConfigurationArgs>) {
        this.ecrConfiguration = value
    }

    /**
     * @param value Indicates whether Image Builder keeps a snapshot of the vulnerability scans that Amazon Inspector runs against the build instance when you create a new image. Defaults to `false`.
     */
    @JvmName("nbwqbxjguetfahbd")
    public suspend fun imageScanningEnabled(`value`: Output<Boolean>) {
        this.imageScanningEnabled = value
    }

    /**
     * @param value Configuration block with ECR configuration. Detailed below.
     */
    @JvmName("qmrqenudndahlwuu")
    public suspend fun ecrConfiguration(`value`: ImageImageScanningConfigurationEcrConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecrConfiguration = mapped
    }

    /**
     * @param argument Configuration block with ECR configuration. Detailed below.
     */
    @JvmName("gcplbwcxpqurmlso")
    public suspend fun ecrConfiguration(argument: suspend ImageImageScanningConfigurationEcrConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ImageImageScanningConfigurationEcrConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ecrConfiguration = mapped
    }

    /**
     * @param value Indicates whether Image Builder keeps a snapshot of the vulnerability scans that Amazon Inspector runs against the build instance when you create a new image. Defaults to `false`.
     */
    @JvmName("pifgojinccndxgmb")
    public suspend fun imageScanningEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageScanningEnabled = mapped
    }

    internal fun build(): ImageImageScanningConfigurationArgs = ImageImageScanningConfigurationArgs(
        ecrConfiguration = ecrConfiguration,
        imageScanningEnabled = imageScanningEnabled,
    )
}
