@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImageImageTestsConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property imageTestsEnabled Whether image tests are enabled. Defaults to `true`.
 * @property timeoutMinutes Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
 */
public data class ImageImageTestsConfigurationArgs(
    public val imageTestsEnabled: Output<Boolean>? = null,
    public val timeoutMinutes: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImageImageTestsConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ImageImageTestsConfigurationArgs =
        com.pulumi.aws.imagebuilder.inputs.ImageImageTestsConfigurationArgs.builder()
            .imageTestsEnabled(imageTestsEnabled?.applyValue({ args0 -> args0 }))
            .timeoutMinutes(timeoutMinutes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageImageTestsConfigurationArgs].
 */
@PulumiTagMarker
public class ImageImageTestsConfigurationArgsBuilder internal constructor() {
    private var imageTestsEnabled: Output<Boolean>? = null

    private var timeoutMinutes: Output<Int>? = null

    /**
     * @param value Whether image tests are enabled. Defaults to `true`.
     */
    @JvmName("misylwhgxwjgflwu")
    public suspend fun imageTestsEnabled(`value`: Output<Boolean>) {
        this.imageTestsEnabled = value
    }

    /**
     * @param value Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
     */
    @JvmName("ajswsuuaqaqsuwjs")
    public suspend fun timeoutMinutes(`value`: Output<Int>) {
        this.timeoutMinutes = value
    }

    /**
     * @param value Whether image tests are enabled. Defaults to `true`.
     */
    @JvmName("dkjwocvjqrjyanko")
    public suspend fun imageTestsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageTestsEnabled = mapped
    }

    /**
     * @param value Number of minutes before image tests time out. Valid values are between `60` and `1440`. Defaults to `720`.
     */
    @JvmName("mxgvuphsucromiys")
    public suspend fun timeoutMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutMinutes = mapped
    }

    internal fun build(): ImageImageTestsConfigurationArgs = ImageImageTestsConfigurationArgs(
        imageTestsEnabled = imageTestsEnabled,
        timeoutMinutes = timeoutMinutes,
    )
}
