@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImagePipelineImageScanningConfigurationEcrConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property containerTags
 * @property repositoryName The name of the repository to scan
 */
public data class ImagePipelineImageScanningConfigurationEcrConfigurationArgs(
    public val containerTags: Output<List<String>>? = null,
    public val repositoryName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImagePipelineImageScanningConfigurationEcrConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ImagePipelineImageScanningConfigurationEcrConfigurationArgs =
        com.pulumi.aws.imagebuilder.inputs.ImagePipelineImageScanningConfigurationEcrConfigurationArgs.builder()
            .containerTags(containerTags?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .repositoryName(repositoryName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImagePipelineImageScanningConfigurationEcrConfigurationArgs].
 */
@PulumiTagMarker
public class ImagePipelineImageScanningConfigurationEcrConfigurationArgsBuilder internal constructor() {
    private var containerTags: Output<List<String>>? = null

    private var repositoryName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("gpsfdkclvyesamhi")
    public suspend fun containerTags(`value`: Output<List<String>>) {
        this.containerTags = value
    }

    @JvmName("cbntqfjvmkdhqvph")
    public suspend fun containerTags(vararg values: Output<String>) {
        this.containerTags = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("tpbhlqugxqloeixt")
    public suspend fun containerTags(values: List<Output<String>>) {
        this.containerTags = Output.all(values)
    }

    /**
     * @param value The name of the repository to scan
     */
    @JvmName("krpdwiborycyhvto")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value
     */
    @JvmName("wsbhpaibncskkwqq")
    public suspend fun containerTags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerTags = mapped
    }

    /**
     * @param values
     */
    @JvmName("kmvrcokisqhlarwm")
    public suspend fun containerTags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.containerTags = mapped
    }

    /**
     * @param value The name of the repository to scan
     */
    @JvmName("ivufgsardvugtncy")
    public suspend fun repositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    internal fun build(): ImagePipelineImageScanningConfigurationEcrConfigurationArgs =
        ImagePipelineImageScanningConfigurationEcrConfigurationArgs(
            containerTags = containerTags,
            repositoryName = repositoryName,
        )
}
