@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImagePipelineScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property pipelineExecutionStartCondition Condition when the pipeline should trigger a new image build. Valid values are `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE` and `EXPRESSION_MATCH_ONLY`. Defaults to `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE`.
 * @property scheduleExpression Cron expression of how often the pipeline start condition is evaluated. For example, `cron(0 0 * * ? *)` is evaluated every day at midnight UTC. Configurations using the five field syntax that was previously accepted by the API, such as `cron(0 0 * * *)`, must be updated to the six field syntax. For more information, see the [Image Builder User Guide](https://docs.aws.amazon.com/imagebuilder/latest/userguide/cron-expressions.html).
 * The following arguments are optional:
 * @property timezone The timezone that applies to the scheduling expression. For example, "Etc/UTC", "America/Los_Angeles" in the [IANA timezone format](https://www.joda.org/joda-time/timezones.html). If not specified this defaults to UTC.
 */
public data class ImagePipelineScheduleArgs(
    public val pipelineExecutionStartCondition: Output<String>? = null,
    public val scheduleExpression: Output<String>,
    public val timezone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImagePipelineScheduleArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ImagePipelineScheduleArgs =
        com.pulumi.aws.imagebuilder.inputs.ImagePipelineScheduleArgs.builder()
            .pipelineExecutionStartCondition(pipelineExecutionStartCondition?.applyValue({ args0 -> args0 }))
            .scheduleExpression(scheduleExpression.applyValue({ args0 -> args0 }))
            .timezone(timezone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImagePipelineScheduleArgs].
 */
@PulumiTagMarker
public class ImagePipelineScheduleArgsBuilder internal constructor() {
    private var pipelineExecutionStartCondition: Output<String>? = null

    private var scheduleExpression: Output<String>? = null

    private var timezone: Output<String>? = null

    /**
     * @param value Condition when the pipeline should trigger a new image build. Valid values are `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE` and `EXPRESSION_MATCH_ONLY`. Defaults to `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE`.
     */
    @JvmName("ajiqljxgnofulexy")
    public suspend fun pipelineExecutionStartCondition(`value`: Output<String>) {
        this.pipelineExecutionStartCondition = value
    }

    /**
     * @param value Cron expression of how often the pipeline start condition is evaluated. For example, `cron(0 0 * * ? *)` is evaluated every day at midnight UTC. Configurations using the five field syntax that was previously accepted by the API, such as `cron(0 0 * * *)`, must be updated to the six field syntax. For more information, see the [Image Builder User Guide](https://docs.aws.amazon.com/imagebuilder/latest/userguide/cron-expressions.html).
     * The following arguments are optional:
     */
    @JvmName("mrmyvbdfcbnsknpv")
    public suspend fun scheduleExpression(`value`: Output<String>) {
        this.scheduleExpression = value
    }

    /**
     * @param value The timezone that applies to the scheduling expression. For example, "Etc/UTC", "America/Los_Angeles" in the [IANA timezone format](https://www.joda.org/joda-time/timezones.html). If not specified this defaults to UTC.
     */
    @JvmName("iqdcooqfgvrndgri")
    public suspend fun timezone(`value`: Output<String>) {
        this.timezone = value
    }

    /**
     * @param value Condition when the pipeline should trigger a new image build. Valid values are `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE` and `EXPRESSION_MATCH_ONLY`. Defaults to `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE`.
     */
    @JvmName("nsfogglgtndbsiar")
    public suspend fun pipelineExecutionStartCondition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pipelineExecutionStartCondition = mapped
    }

    /**
     * @param value Cron expression of how often the pipeline start condition is evaluated. For example, `cron(0 0 * * ? *)` is evaluated every day at midnight UTC. Configurations using the five field syntax that was previously accepted by the API, such as `cron(0 0 * * *)`, must be updated to the six field syntax. For more information, see the [Image Builder User Guide](https://docs.aws.amazon.com/imagebuilder/latest/userguide/cron-expressions.html).
     * The following arguments are optional:
     */
    @JvmName("ktkdnhktkybffneh")
    public suspend fun scheduleExpression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleExpression = mapped
    }

    /**
     * @param value The timezone that applies to the scheduling expression. For example, "Etc/UTC", "America/Los_Angeles" in the [IANA timezone format](https://www.joda.org/joda-time/timezones.html). If not specified this defaults to UTC.
     */
    @JvmName("adlptomrdlmfqaaw")
    public suspend fun timezone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timezone = mapped
    }

    internal fun build(): ImagePipelineScheduleArgs = ImagePipelineScheduleArgs(
        pipelineExecutionStartCondition = pipelineExecutionStartCondition,
        scheduleExpression = scheduleExpression ?: throw PulumiNullFieldException("scheduleExpression"),
        timezone = timezone,
    )
}
