@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImagePipelineWorkflowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property onFailure The action to take if the workflow fails. Must be one of `CONTINUE` or `ABORT`.
 * @property parallelGroup The parallel group in which to run a test Workflow.
 * @property parameters Configuration block for the workflow parameters. Detailed below.
 * @property workflowArn Amazon Resource Name (ARN) of the Image Builder Workflow.
 * The following arguments are optional:
 */
public data class ImagePipelineWorkflowArgs(
    public val onFailure: Output<String>? = null,
    public val parallelGroup: Output<String>? = null,
    public val parameters: Output<List<ImagePipelineWorkflowParameterArgs>>? = null,
    public val workflowArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImagePipelineWorkflowArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ImagePipelineWorkflowArgs =
        com.pulumi.aws.imagebuilder.inputs.ImagePipelineWorkflowArgs.builder()
            .onFailure(onFailure?.applyValue({ args0 -> args0 }))
            .parallelGroup(parallelGroup?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .workflowArn(workflowArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImagePipelineWorkflowArgs].
 */
@PulumiTagMarker
public class ImagePipelineWorkflowArgsBuilder internal constructor() {
    private var onFailure: Output<String>? = null

    private var parallelGroup: Output<String>? = null

    private var parameters: Output<List<ImagePipelineWorkflowParameterArgs>>? = null

    private var workflowArn: Output<String>? = null

    /**
     * @param value The action to take if the workflow fails. Must be one of `CONTINUE` or `ABORT`.
     */
    @JvmName("etctqcljankcvuwj")
    public suspend fun onFailure(`value`: Output<String>) {
        this.onFailure = value
    }

    /**
     * @param value The parallel group in which to run a test Workflow.
     */
    @JvmName("xnphnjllmcpkwlsf")
    public suspend fun parallelGroup(`value`: Output<String>) {
        this.parallelGroup = value
    }

    /**
     * @param value Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("bpfgracitngxbgur")
    public suspend fun parameters(`value`: Output<List<ImagePipelineWorkflowParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("munrnldlbtfvpgjc")
    public suspend fun parameters(vararg values: Output<ImagePipelineWorkflowParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("biiyduvwqiiqpabb")
    public suspend fun parameters(values: List<Output<ImagePipelineWorkflowParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Workflow.
     * The following arguments are optional:
     */
    @JvmName("kiyeubaqpbcleiys")
    public suspend fun workflowArn(`value`: Output<String>) {
        this.workflowArn = value
    }

    /**
     * @param value The action to take if the workflow fails. Must be one of `CONTINUE` or `ABORT`.
     */
    @JvmName("bdurjmkasmmlpjtr")
    public suspend fun onFailure(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onFailure = mapped
    }

    /**
     * @param value The parallel group in which to run a test Workflow.
     */
    @JvmName("dvhaprvmrnjarpyx")
    public suspend fun parallelGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelGroup = mapped
    }

    /**
     * @param value Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("ryvduidysbxcytmq")
    public suspend fun parameters(`value`: List<ImagePipelineWorkflowParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("nfdwmtdmkymjivix")
    public suspend fun parameters(argument: List<suspend ImagePipelineWorkflowParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImagePipelineWorkflowParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("iwdekxmpownoyhjp")
    public suspend fun parameters(vararg argument: suspend ImagePipelineWorkflowParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImagePipelineWorkflowParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("qptpxwuqbecrvubc")
    public suspend fun parameters(argument: suspend ImagePipelineWorkflowParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ImagePipelineWorkflowParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("dpqsrqdqthlomnbh")
    public suspend fun parameters(vararg values: ImagePipelineWorkflowParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Workflow.
     * The following arguments are optional:
     */
    @JvmName("lqvruvrxsulnrjar")
    public suspend fun workflowArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workflowArn = mapped
    }

    internal fun build(): ImagePipelineWorkflowArgs = ImagePipelineWorkflowArgs(
        onFailure = onFailure,
        parallelGroup = parallelGroup,
        parameters = parameters,
        workflowArn = workflowArn ?: throw PulumiNullFieldException("workflowArn"),
    )
}
