@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImagePipelineWorkflowParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the Workflow parameter.
 * @property value The value of the Workflow parameter.
 */
public data class ImagePipelineWorkflowParameterArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImagePipelineWorkflowParameterArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ImagePipelineWorkflowParameterArgs =
        com.pulumi.aws.imagebuilder.inputs.ImagePipelineWorkflowParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImagePipelineWorkflowParameterArgs].
 */
@PulumiTagMarker
public class ImagePipelineWorkflowParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the Workflow parameter.
     */
    @JvmName("iimprfoalyravsiw")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the Workflow parameter.
     */
    @JvmName("anictqskqanrpbyk")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the Workflow parameter.
     */
    @JvmName("volpatwkyavsiqpp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the Workflow parameter.
     */
    @JvmName("typjmlqpmurdmdxc")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ImagePipelineWorkflowParameterArgs = ImagePipelineWorkflowParameterArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
