@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImageRecipeComponentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property componentArn Amazon Resource Name (ARN) of the Image Builder Component to associate.
 * @property parameters Configuration block(s) for parameters to configure the component. Detailed below.
 */
public data class ImageRecipeComponentArgs(
    public val componentArn: Output<String>,
    public val parameters: Output<List<ImageRecipeComponentParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImageRecipeComponentArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ImageRecipeComponentArgs =
        com.pulumi.aws.imagebuilder.inputs.ImageRecipeComponentArgs.builder()
            .componentArn(componentArn.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ImageRecipeComponentArgs].
 */
@PulumiTagMarker
public class ImageRecipeComponentArgsBuilder internal constructor() {
    private var componentArn: Output<String>? = null

    private var parameters: Output<List<ImageRecipeComponentParameterArgs>>? = null

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Component to associate.
     */
    @JvmName("crwqoimmdtwnmepb")
    public suspend fun componentArn(`value`: Output<String>) {
        this.componentArn = value
    }

    /**
     * @param value Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("vripnlhmtxaaddef")
    public suspend fun parameters(`value`: Output<List<ImageRecipeComponentParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("hoylyojgkugvpxly")
    public suspend fun parameters(vararg values: Output<ImageRecipeComponentParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("ekhwahpdvsateeac")
    public suspend fun parameters(values: List<Output<ImageRecipeComponentParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Component to associate.
     */
    @JvmName("nyddcldqaendwkpf")
    public suspend fun componentArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.componentArn = mapped
    }

    /**
     * @param value Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("uxjlospliepesxso")
    public suspend fun parameters(`value`: List<ImageRecipeComponentParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("brujxuyeovstnfrk")
    public suspend fun parameters(argument: List<suspend ImageRecipeComponentParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImageRecipeComponentParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("qgvqfihpvlbwpwdc")
    public suspend fun parameters(vararg argument: suspend ImageRecipeComponentParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImageRecipeComponentParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("cacmqhhyniqqxdiy")
    public suspend fun parameters(argument: suspend ImageRecipeComponentParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ImageRecipeComponentParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Configuration block(s) for parameters to configure the component. Detailed below.
     */
    @JvmName("dexwaltfftkimpnn")
    public suspend fun parameters(vararg values: ImageRecipeComponentParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    internal fun build(): ImageRecipeComponentArgs = ImageRecipeComponentArgs(
        componentArn = componentArn ?: throw PulumiNullFieldException("componentArn"),
        parameters = parameters,
    )
}
