@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImageRecipeComponentParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the component parameter.
 * @property value The value for the named component parameter.
 */
public data class ImageRecipeComponentParameterArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImageRecipeComponentParameterArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ImageRecipeComponentParameterArgs =
        com.pulumi.aws.imagebuilder.inputs.ImageRecipeComponentParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageRecipeComponentParameterArgs].
 */
@PulumiTagMarker
public class ImageRecipeComponentParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the component parameter.
     */
    @JvmName("onqcikmttjhppnft")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value for the named component parameter.
     */
    @JvmName("gmelwsrwajgtoely")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the component parameter.
     */
    @JvmName("yqojvsksxufkoxwo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value for the named component parameter.
     */
    @JvmName("gkdlxinqmumpctjs")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ImageRecipeComponentParameterArgs = ImageRecipeComponentParameterArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
