@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImageRecipeSystemsManagerAgentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property uninstallAfterBuild Whether to remove the Systems Manager Agent after the image has been built. Defaults to `false`.
 */
public data class ImageRecipeSystemsManagerAgentArgs(
    public val uninstallAfterBuild: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImageRecipeSystemsManagerAgentArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ImageRecipeSystemsManagerAgentArgs =
        com.pulumi.aws.imagebuilder.inputs.ImageRecipeSystemsManagerAgentArgs.builder()
            .uninstallAfterBuild(uninstallAfterBuild.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageRecipeSystemsManagerAgentArgs].
 */
@PulumiTagMarker
public class ImageRecipeSystemsManagerAgentArgsBuilder internal constructor() {
    private var uninstallAfterBuild: Output<Boolean>? = null

    /**
     * @param value Whether to remove the Systems Manager Agent after the image has been built. Defaults to `false`.
     */
    @JvmName("ogctenpdiegnjsjb")
    public suspend fun uninstallAfterBuild(`value`: Output<Boolean>) {
        this.uninstallAfterBuild = value
    }

    /**
     * @param value Whether to remove the Systems Manager Agent after the image has been built. Defaults to `false`.
     */
    @JvmName("dvejixlwonekbxlw")
    public suspend fun uninstallAfterBuild(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uninstallAfterBuild = mapped
    }

    internal fun build(): ImageRecipeSystemsManagerAgentArgs = ImageRecipeSystemsManagerAgentArgs(
        uninstallAfterBuild = uninstallAfterBuild ?: throw PulumiNullFieldException("uninstallAfterBuild"),
    )
}
