@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.inputs

import com.pulumi.aws.imagebuilder.inputs.ImageWorkflowArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property onFailure The action to take if the workflow fails. Must be one of `CONTINUE` or `ABORT`.
 * @property parallelGroup The parallel group in which to run a test Workflow.
 * @property parameters Configuration block for the workflow parameters. Detailed below.
 * @property workflowArn Amazon Resource Name (ARN) of the Image Builder Workflow.
 * The following arguments are optional:
 */
public data class ImageWorkflowArgs(
    public val onFailure: Output<String>? = null,
    public val parallelGroup: Output<String>? = null,
    public val parameters: Output<List<ImageWorkflowParameterArgs>>? = null,
    public val workflowArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.imagebuilder.inputs.ImageWorkflowArgs> {
    override fun toJava(): com.pulumi.aws.imagebuilder.inputs.ImageWorkflowArgs =
        com.pulumi.aws.imagebuilder.inputs.ImageWorkflowArgs.builder()
            .onFailure(onFailure?.applyValue({ args0 -> args0 }))
            .parallelGroup(parallelGroup?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .workflowArn(workflowArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageWorkflowArgs].
 */
@PulumiTagMarker
public class ImageWorkflowArgsBuilder internal constructor() {
    private var onFailure: Output<String>? = null

    private var parallelGroup: Output<String>? = null

    private var parameters: Output<List<ImageWorkflowParameterArgs>>? = null

    private var workflowArn: Output<String>? = null

    /**
     * @param value The action to take if the workflow fails. Must be one of `CONTINUE` or `ABORT`.
     */
    @JvmName("pkcbavvygbspdraj")
    public suspend fun onFailure(`value`: Output<String>) {
        this.onFailure = value
    }

    /**
     * @param value The parallel group in which to run a test Workflow.
     */
    @JvmName("vxvvgkyrjloxsger")
    public suspend fun parallelGroup(`value`: Output<String>) {
        this.parallelGroup = value
    }

    /**
     * @param value Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("uflxljmfritctyjr")
    public suspend fun parameters(`value`: Output<List<ImageWorkflowParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("esqenjskweeecfli")
    public suspend fun parameters(vararg values: Output<ImageWorkflowParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("lyjkuqaopxeeulvh")
    public suspend fun parameters(values: List<Output<ImageWorkflowParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Workflow.
     * The following arguments are optional:
     */
    @JvmName("slwaounecbgwkmrl")
    public suspend fun workflowArn(`value`: Output<String>) {
        this.workflowArn = value
    }

    /**
     * @param value The action to take if the workflow fails. Must be one of `CONTINUE` or `ABORT`.
     */
    @JvmName("egsejvkxixexqmhs")
    public suspend fun onFailure(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onFailure = mapped
    }

    /**
     * @param value The parallel group in which to run a test Workflow.
     */
    @JvmName("matgmkpavmjsppce")
    public suspend fun parallelGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parallelGroup = mapped
    }

    /**
     * @param value Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("eraxiawkwkumktej")
    public suspend fun parameters(`value`: List<ImageWorkflowParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("goocwddgjttyiftn")
    public suspend fun parameters(argument: List<suspend ImageWorkflowParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImageWorkflowParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("vrjpccadsckjklao")
    public suspend fun parameters(vararg argument: suspend ImageWorkflowParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImageWorkflowParameterArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("wytugqghknycckux")
    public suspend fun parameters(argument: suspend ImageWorkflowParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ImageWorkflowParameterArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Configuration block for the workflow parameters. Detailed below.
     */
    @JvmName("qqwdlaingqytwlvr")
    public suspend fun parameters(vararg values: ImageWorkflowParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the Image Builder Workflow.
     * The following arguments are optional:
     */
    @JvmName("lwxljjkobdajacib")
    public suspend fun workflowArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workflowArn = mapped
    }

    internal fun build(): ImageWorkflowArgs = ImageWorkflowArgs(
        onFailure = onFailure,
        parallelGroup = parallelGroup,
        parameters = parameters,
        workflowArn = workflowArn ?: throw PulumiNullFieldException("workflowArn"),
    )
}
