@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property repositoryName The name of the container repository where the output container image is stored. This name is prefixed by the repository location.
 * @property service The service in which this image is registered. Valid values: `ECR`.
 */
public data class ContainerRecipeTargetRepository(
    public val repositoryName: String,
    public val service: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ContainerRecipeTargetRepository): ContainerRecipeTargetRepository = ContainerRecipeTargetRepository(
            repositoryName = javaType.repositoryName(),
            service = javaType.service(),
        )
    }
}
