@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containerTags Set of tags that are attached to the container distribution configuration.
 * @property description Description of the container distribution configuration.
 * @property targetRepository Configuration block with the destination repository for the container distribution configuration.
 */
public data class DistributionConfigurationDistributionContainerDistributionConfiguration(
    public val containerTags: List<String>? = null,
    public val description: String? = null,
    public val targetRepository: DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepository,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.DistributionConfigurationDistributionContainerDistributionConfiguration): DistributionConfigurationDistributionContainerDistributionConfiguration =
            DistributionConfigurationDistributionContainerDistributionConfiguration(
                containerTags = javaType.containerTags().map({ args0 -> args0 }),
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                targetRepository = javaType.targetRepository().let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.DistributionConfigurationDistributionContainerDistributionConfigurationTargetRepository.Companion.toKotlin(args0)
                }),
            )
    }
}
