@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId The owner account ID for the fast-launch enabled Windows AMI.
 * @property enabled A Boolean that represents the current state of faster launching for the Windows AMI. Set to `true` to start using Windows faster launching, or `false` to stop using it.
 * @property launchTemplate Configuration block for the launch template that the fast-launch enabled Windows AMI uses when it launches Windows instances to create pre-provisioned snapshots. Detailed below.
 * @property maxParallelLaunches The maximum number of parallel instances that are launched for creating resources.
 * @property snapshotConfiguration Configuration block for managing the number of snapshots that are created from pre-provisioned instances for the Windows AMI when faster launching is enabled. Detailed below.
 */
public data class DistributionConfigurationDistributionFastLaunchConfiguration(
    public val accountId: String,
    public val enabled: Boolean,
    public val launchTemplate: DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplate? = null,
    public val maxParallelLaunches: Int? = null,
    public val snapshotConfiguration: DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.DistributionConfigurationDistributionFastLaunchConfiguration): DistributionConfigurationDistributionFastLaunchConfiguration =
            DistributionConfigurationDistributionFastLaunchConfiguration(
                accountId = javaType.accountId(),
                enabled = javaType.enabled(),
                launchTemplate = javaType.launchTemplate().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.imagebuilder.kotlin.outputs.DistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplate.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                maxParallelLaunches = javaType.maxParallelLaunches().map({ args0 -> args0 }).orElse(null),
                snapshotConfiguration = javaType.snapshotConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.imagebuilder.kotlin.outputs.DistributionConfigurationDistributionFastLaunchConfigurationSnapshotConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
