@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accountId The account ID that this configuration applies to.
 * @property default Indicates whether to set the specified Amazon EC2 launch template as the default launch template. Defaults to `true`.
 * @property launchTemplateId The ID of the Amazon EC2 launch template to use.
 */
public data class DistributionConfigurationDistributionLaunchTemplateConfiguration(
    public val accountId: String? = null,
    public val default: Boolean? = null,
    public val launchTemplateId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.DistributionConfigurationDistributionLaunchTemplateConfiguration): DistributionConfigurationDistributionLaunchTemplateConfiguration =
            DistributionConfigurationDistributionLaunchTemplateConfiguration(
                accountId = javaType.accountId().map({ args0 -> args0 }).orElse(null),
                default = javaType.default_().map({ args0 -> args0 }).orElse(null),
                launchTemplateId = javaType.launchTemplateId(),
            )
    }
}
