@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property blockDeviceMappings Set of objects with block device mappings for the instance configuration.
 * @property image AMI ID of the base image for container build and test instance.
 */
public data class GetContainerRecipeInstanceConfiguration(
    public val blockDeviceMappings: List<GetContainerRecipeInstanceConfigurationBlockDeviceMapping>,
    public val image: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetContainerRecipeInstanceConfiguration): GetContainerRecipeInstanceConfiguration = GetContainerRecipeInstanceConfiguration(
            blockDeviceMappings = javaType.blockDeviceMappings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetContainerRecipeInstanceConfigurationBlockDeviceMapping.Companion.toKotlin(args0)
                })
            }),
            image = javaType.image(),
        )
    }
}
