@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property deviceName Name of the device. For example, `/dev/sda` or `/dev/xvdb`.
 * @property ebs Single list of object with Elastic Block Storage (EBS) block device mapping settings.
 * @property noDevice Whether to remove a mapping from the parent image.
 * @property virtualName Virtual device name. For example, `ephemeral0`. Instance store volumes are numbered starting from 0.
 */
public data class GetContainerRecipeInstanceConfigurationBlockDeviceMapping(
    public val deviceName: String,
    public val ebs: List<GetContainerRecipeInstanceConfigurationBlockDeviceMappingEb>,
    public val noDevice: String,
    public val virtualName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetContainerRecipeInstanceConfigurationBlockDeviceMapping): GetContainerRecipeInstanceConfigurationBlockDeviceMapping =
            GetContainerRecipeInstanceConfigurationBlockDeviceMapping(
                deviceName = javaType.deviceName(),
                ebs = javaType.ebs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.imagebuilder.kotlin.outputs.GetContainerRecipeInstanceConfigurationBlockDeviceMappingEb.Companion.toKotlin(args0)
                    })
                }),
                noDevice = javaType.noDevice(),
                virtualName = javaType.virtualName(),
            )
    }
}
