@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getContainerRecipe.
 * @property arn
 * @property components List of objects with components for the container recipe.
 * @property containerType Type of the container.
 * @property dateCreated Date the container recipe was created.
 * @property description Description of the container recipe.
 * @property dockerfileTemplateData Dockerfile template used to build the image.
 * @property encrypted Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceConfigurations List of objects with instance configurations for building and testing container images.
 * @property kmsKeyId KMS key used to encrypt the container image.
 * @property name Name of the container recipe.
 * @property owner Owner of the container recipe.
 * @property parentImage Base image for the container recipe.
 * @property platform Platform of the container recipe.
 * @property tags Key-value map of resource tags for the container recipe.
 * @property targetRepositories Destination repository for the container image.
 * @property version Version of the container recipe.
 * @property workingDirectory Working directory used during build and test workflows.
 */
public data class GetContainerRecipeResult(
    public val arn: String,
    public val components: List<GetContainerRecipeComponent>,
    public val containerType: String,
    public val dateCreated: String,
    public val description: String,
    public val dockerfileTemplateData: String,
    public val encrypted: Boolean,
    public val id: String,
    public val instanceConfigurations: List<GetContainerRecipeInstanceConfiguration>,
    public val kmsKeyId: String,
    public val name: String,
    public val owner: String,
    public val parentImage: String,
    public val platform: String,
    public val tags: Map<String, String>? = null,
    public val targetRepositories: List<GetContainerRecipeTargetRepository>,
    public val version: String,
    public val workingDirectory: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetContainerRecipeResult): GetContainerRecipeResult = GetContainerRecipeResult(
            arn = javaType.arn(),
            components = javaType.components().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetContainerRecipeComponent.Companion.toKotlin(args0)
                })
            }),
            containerType = javaType.containerType(),
            dateCreated = javaType.dateCreated(),
            description = javaType.description(),
            dockerfileTemplateData = javaType.dockerfileTemplateData(),
            encrypted = javaType.encrypted(),
            id = javaType.id(),
            instanceConfigurations = javaType.instanceConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetContainerRecipeInstanceConfiguration.Companion.toKotlin(args0)
                })
            }),
            kmsKeyId = javaType.kmsKeyId(),
            name = javaType.name(),
            owner = javaType.owner(),
            parentImage = javaType.parentImage(),
            platform = javaType.platform(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetRepositories = javaType.targetRepositories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetContainerRecipeTargetRepository.Companion.toKotlin(args0)
                })
            }),
            version = javaType.version(),
            workingDirectory = javaType.workingDirectory(),
        )
    }
}
