@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property launchTemplateId ID of the Amazon EC2 launch template.
 * @property launchTemplateName The name of the launch template to use for faster launching for a Windows AMI.
 * @property launchTemplateVersion The version of the launch template to use for faster launching for a Windows AMI.
 */
public data class GetDistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplate(
    public val launchTemplateId: String,
    public val launchTemplateName: String,
    public val launchTemplateVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetDistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplate): GetDistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplate =
            GetDistributionConfigurationDistributionFastLaunchConfigurationLaunchTemplate(
                launchTemplateId = javaType.launchTemplateId(),
                launchTemplateName = javaType.launchTemplateName(),
                launchTemplateVersion = javaType.launchTemplateVersion(),
            )
    }
}
