@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ecrConfigurations Configuration block with ECR configuration.
 * @property imageScanningEnabled Indicates whether Image Builder keeps a snapshot of the vulnerability scans that Amazon Inspector runs against the build instance when you create a new image.
 */
public data class GetImageImageScanningConfiguration(
    public val ecrConfigurations: List<GetImageImageScanningConfigurationEcrConfiguration>,
    public val imageScanningEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImageImageScanningConfiguration): GetImageImageScanningConfiguration = GetImageImageScanningConfiguration(
            ecrConfigurations = javaType.ecrConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageImageScanningConfigurationEcrConfiguration.Companion.toKotlin(args0)
                })
            }),
            imageScanningEnabled = javaType.imageScanningEnabled(),
        )
    }
}
