@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property imageTestsEnabled Whether image tests are enabled.
 * @property timeoutMinutes Number of minutes before image tests time out.
 */
public data class GetImageImageTestsConfiguration(
    public val imageTestsEnabled: Boolean,
    public val timeoutMinutes: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImageImageTestsConfiguration): GetImageImageTestsConfiguration = GetImageImageTestsConfiguration(
            imageTestsEnabled = javaType.imageTestsEnabled(),
            timeoutMinutes = javaType.timeoutMinutes(),
        )
    }
}
