@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property amis Set of objects with each Amazon Machine Image (AMI) created.
 * @property containers Set of objects with each container image created and stored in the output repository.
 */
public data class GetImageOutputResource(
    public val amis: List<GetImageOutputResourceAmi>,
    public val containers: List<GetImageOutputResourceContainer>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImageOutputResource): GetImageOutputResource = GetImageOutputResource(
            amis = javaType.amis().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageOutputResourceAmi.Companion.toKotlin(args0)
                })
            }),
            containers = javaType.containers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImageOutputResourceContainer.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
