@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ecrConfigurations List if an object with ecr configuration for image scanning
 * @property imageScanningEnabled Whether image scanning is enabled.
 */
public data class GetImagePipelineImageScanningConfiguration(
    public val ecrConfigurations: List<GetImagePipelineImageScanningConfigurationEcrConfiguration>,
    public val imageScanningEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImagePipelineImageScanningConfiguration): GetImagePipelineImageScanningConfiguration = GetImagePipelineImageScanningConfiguration(
            ecrConfigurations = javaType.ecrConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImagePipelineImageScanningConfigurationEcrConfiguration.Companion.toKotlin(args0)
                })
            }),
            imageScanningEnabled = javaType.imageScanningEnabled(),
        )
    }
}
