@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getImagePipeline.
 * @property arn
 * @property containerRecipeArn ARN of the container recipe.
 * @property dateCreated Date the image pipeline was created.
 * @property dateLastRun Date the image pipeline was last run.
 * @property dateNextRun Date the image pipeline will run next.
 * @property dateUpdated Date the image pipeline was updated.
 * @property description Description of the image pipeline.
 * @property distributionConfigurationArn ARN of the Image Builder Distribution Configuration.
 * @property enhancedImageMetadataEnabled Whether additional information about the image being created is collected.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property imageRecipeArn ARN of the image recipe.
 * @property imageScanningConfigurations
 * @property imageTestsConfigurations List of an object with image tests configuration.
 * @property infrastructureConfigurationArn ARN of the Image Builder Infrastructure Configuration.
 * @property name Name of the image pipeline.
 * @property platform Platform of the image pipeline.
 * @property schedules List of an object with schedule settings.
 * @property status Status of the image pipeline.
 * @property tags Key-value map of resource tags for the image pipeline.
 */
public data class GetImagePipelineResult(
    public val arn: String,
    public val containerRecipeArn: String,
    public val dateCreated: String,
    public val dateLastRun: String,
    public val dateNextRun: String,
    public val dateUpdated: String,
    public val description: String,
    public val distributionConfigurationArn: String,
    public val enhancedImageMetadataEnabled: Boolean,
    public val id: String,
    public val imageRecipeArn: String,
    public val imageScanningConfigurations: List<GetImagePipelineImageScanningConfiguration>,
    public val imageTestsConfigurations: List<GetImagePipelineImageTestsConfiguration>,
    public val infrastructureConfigurationArn: String,
    public val name: String,
    public val platform: String,
    public val schedules: List<GetImagePipelineSchedule>,
    public val status: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImagePipelineResult): GetImagePipelineResult = GetImagePipelineResult(
            arn = javaType.arn(),
            containerRecipeArn = javaType.containerRecipeArn(),
            dateCreated = javaType.dateCreated(),
            dateLastRun = javaType.dateLastRun(),
            dateNextRun = javaType.dateNextRun(),
            dateUpdated = javaType.dateUpdated(),
            description = javaType.description(),
            distributionConfigurationArn = javaType.distributionConfigurationArn(),
            enhancedImageMetadataEnabled = javaType.enhancedImageMetadataEnabled(),
            id = javaType.id(),
            imageRecipeArn = javaType.imageRecipeArn(),
            imageScanningConfigurations = javaType.imageScanningConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImagePipelineImageScanningConfiguration.Companion.toKotlin(args0)
                })
            }),
            imageTestsConfigurations = javaType.imageTestsConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImagePipelineImageTestsConfiguration.Companion.toKotlin(args0)
                })
            }),
            infrastructureConfigurationArn = javaType.infrastructureConfigurationArn(),
            name = javaType.name(),
            platform = javaType.platform(),
            schedules = javaType.schedules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetImagePipelineSchedule.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
