@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property pipelineExecutionStartCondition Condition when the pipeline should trigger a new image build.
 * @property scheduleExpression Cron expression of how often the pipeline start condition is evaluated.
 */
public data class GetImagePipelineSchedule(
    public val pipelineExecutionStartCondition: String,
    public val scheduleExpression: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetImagePipelineSchedule): GetImagePipelineSchedule = GetImagePipelineSchedule(
            pipelineExecutionStartCondition = javaType.pipelineExecutionStartCondition(),
            scheduleExpression = javaType.scheduleExpression(),
        )
    }
}
