@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getInfrastructureConfiguration.
 * @property arn
 * @property dateCreated Date the infrastructure configuration was updated.
 * @property dateUpdated
 * @property description Description of the infrastructure configuration.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceMetadataOptions Nested list of instance metadata options for the HTTP requests that pipeline builds use to launch EC2 build and test instances.
 * @property instanceProfileName Name of the IAM Instance Profile associated with the configuration.
 * @property instanceTypes Set of EC2 Instance Types associated with the configuration.
 * @property keyPair Name of the EC2 Key Pair associated with the configuration.
 * @property loggings Nested list of logging settings.
 * @property name Name of the infrastructure configuration.
 * @property resourceTags Key-value map of resource tags for the infrastructure created by the infrastructure configuration.
 * @property securityGroupIds Set of EC2 Security Group identifiers associated with the configuration.
 * @property snsTopicArn ARN of the SNS Topic associated with the configuration.
 * @property subnetId Identifier of the EC2 Subnet associated with the configuration.
 * @property tags Key-value map of resource tags for the infrastructure configuration.
 * @property terminateInstanceOnFailure Whether instances are terminated on failure.
 */
public data class GetInfrastructureConfigurationResult(
    public val arn: String,
    public val dateCreated: String,
    public val dateUpdated: String,
    public val description: String,
    public val id: String,
    public val instanceMetadataOptions: List<GetInfrastructureConfigurationInstanceMetadataOption>,
    public val instanceProfileName: String,
    public val instanceTypes: List<String>,
    public val keyPair: String,
    public val loggings: List<GetInfrastructureConfigurationLogging>,
    public val name: String,
    public val resourceTags: Map<String, String>,
    public val securityGroupIds: List<String>,
    public val snsTopicArn: String,
    public val subnetId: String,
    public val tags: Map<String, String>,
    public val terminateInstanceOnFailure: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetInfrastructureConfigurationResult): GetInfrastructureConfigurationResult = GetInfrastructureConfigurationResult(
            arn = javaType.arn(),
            dateCreated = javaType.dateCreated(),
            dateUpdated = javaType.dateUpdated(),
            description = javaType.description(),
            id = javaType.id(),
            instanceMetadataOptions = javaType.instanceMetadataOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetInfrastructureConfigurationInstanceMetadataOption.Companion.toKotlin(args0)
                })
            }),
            instanceProfileName = javaType.instanceProfileName(),
            instanceTypes = javaType.instanceTypes().map({ args0 -> args0 }),
            keyPair = javaType.keyPair(),
            loggings = javaType.loggings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetInfrastructureConfigurationLogging.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            resourceTags = javaType.resourceTags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            snsTopicArn = javaType.snsTopicArn(),
            subnetId = javaType.subnetId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            terminateInstanceOnFailure = javaType.terminateInstanceOnFailure(),
        )
    }
}
