@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInfrastructureConfigurations.
 * @property arns Set of ARNs of the matched Image Builder Infrastructure Configurations.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property names Set of names of the matched Image Builder Infrastructure Configurations.
 */
public data class GetInfrastructureConfigurationsResult(
    public val arns: List<String>,
    public val filters: List<GetInfrastructureConfigurationsFilter>? = null,
    public val id: String,
    public val names: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.GetInfrastructureConfigurationsResult): GetInfrastructureConfigurationsResult = GetInfrastructureConfigurationsResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.GetInfrastructureConfigurationsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            names = javaType.names().map({ args0 -> args0 }),
        )
    }
}
