@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property containerTags Set of tags for Image Builder to apply to the output container image that that Amazon Inspector scans.
 * @property repositoryName The name of the container repository that Amazon Inspector scans to identify findings for your container images.
 */
public data class ImageImageScanningConfigurationEcrConfiguration(
    public val containerTags: List<String>? = null,
    public val repositoryName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ImageImageScanningConfigurationEcrConfiguration): ImageImageScanningConfigurationEcrConfiguration =
            ImageImageScanningConfigurationEcrConfiguration(
                containerTags = javaType.containerTags().map({ args0 -> args0 }),
                repositoryName = javaType.repositoryName().map({ args0 -> args0 }).orElse(null),
            )
    }
}
