@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property amis Set of objects with each Amazon Machine Image (AMI) created.
 * @property containers Set of objects with each container image created and stored in the output repository.
 */
public data class ImageOutputResource(
    public val amis: List<ImageOutputResourceAmi>? = null,
    public val containers: List<ImageOutputResourceContainer>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ImageOutputResource): ImageOutputResource = ImageOutputResource(
            amis = javaType.amis().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.ImageOutputResourceAmi.Companion.toKotlin(args0)
                })
            }),
            containers = javaType.containers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.ImageOutputResourceContainer.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
