@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property pipelineExecutionStartCondition Condition when the pipeline should trigger a new image build. Valid values are `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE` and `EXPRESSION_MATCH_ONLY`. Defaults to `EXPRESSION_MATCH_AND_DEPENDENCY_UPDATES_AVAILABLE`.
 * @property scheduleExpression Cron expression of how often the pipeline start condition is evaluated. For example, `cron(0 0 * * ? *)` is evaluated every day at midnight UTC. Configurations using the five field syntax that was previously accepted by the API, such as `cron(0 0 * * *)`, must be updated to the six field syntax. For more information, see the [Image Builder User Guide](https://docs.aws.amazon.com/imagebuilder/latest/userguide/cron-expressions.html).
 * The following arguments are optional:
 * @property timezone The timezone that applies to the scheduling expression. For example, "Etc/UTC", "America/Los_Angeles" in the [IANA timezone format](https://www.joda.org/joda-time/timezones.html). If not specified this defaults to UTC.
 */
public data class ImagePipelineSchedule(
    public val pipelineExecutionStartCondition: String? = null,
    public val scheduleExpression: String,
    public val timezone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ImagePipelineSchedule): ImagePipelineSchedule = ImagePipelineSchedule(
            pipelineExecutionStartCondition = javaType.pipelineExecutionStartCondition().map({ args0 ->
                args0
            }).orElse(null),
            scheduleExpression = javaType.scheduleExpression(),
            timezone = javaType.timezone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
