@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deviceName Name of the device. For example, `/dev/sda` or `/dev/xvdb`.
 * @property ebs Configuration block with Elastic Block Storage (EBS) block device mapping settings. Detailed below.
 * @property noDevice Set to `true` to remove a mapping from the parent image.
 * @property virtualName Virtual device name. For example, `ephemeral0`. Instance store volumes are numbered starting from 0.
 */
public data class ImageRecipeBlockDeviceMapping(
    public val deviceName: String? = null,
    public val ebs: ImageRecipeBlockDeviceMappingEbs? = null,
    public val noDevice: Boolean? = null,
    public val virtualName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ImageRecipeBlockDeviceMapping): ImageRecipeBlockDeviceMapping = ImageRecipeBlockDeviceMapping(
            deviceName = javaType.deviceName().map({ args0 -> args0 }).orElse(null),
            ebs = javaType.ebs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.ImageRecipeBlockDeviceMappingEbs.Companion.toKotlin(args0)
                })
            }).orElse(null),
            noDevice = javaType.noDevice().map({ args0 -> args0 }).orElse(null),
            virtualName = javaType.virtualName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
