@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteOnTermination Whether to delete the volume on termination. Defaults to unset, which is the value inherited from the parent image.
 * @property encrypted Whether to encrypt the volume. Defaults to unset, which is the value inherited from the parent image.
 * @property iops Number of Input/Output (I/O) operations per second to provision for an `io1` or `io2` volume.
 * @property kmsKeyId Amazon Resource Name (ARN) of the Key Management Service (KMS) Key for encryption.
 * @property snapshotId Identifier of the EC2 Volume Snapshot.
 * @property throughput For GP3 volumes only. The throughput in MiB/s that the volume supports.
 * @property volumeSize Size of the volume, in GiB.
 * @property volumeType Type of the volume. For example, `gp2` or `io2`.
 */
public data class ImageRecipeBlockDeviceMappingEbs(
    public val deleteOnTermination: String? = null,
    public val encrypted: String? = null,
    public val iops: Int? = null,
    public val kmsKeyId: String? = null,
    public val snapshotId: String? = null,
    public val throughput: Int? = null,
    public val volumeSize: Int? = null,
    public val volumeType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ImageRecipeBlockDeviceMappingEbs): ImageRecipeBlockDeviceMappingEbs = ImageRecipeBlockDeviceMappingEbs(
            deleteOnTermination = javaType.deleteOnTermination().map({ args0 -> args0 }).orElse(null),
            encrypted = javaType.encrypted().map({ args0 -> args0 }).orElse(null),
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId().map({ args0 -> args0 }).orElse(null),
            throughput = javaType.throughput().map({ args0 -> args0 }).orElse(null),
            volumeSize = javaType.volumeSize().map({ args0 -> args0 }).orElse(null),
            volumeType = javaType.volumeType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
