@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property componentArn Amazon Resource Name (ARN) of the Image Builder Component to associate.
 * @property parameters Configuration block(s) for parameters to configure the component. Detailed below.
 */
public data class ImageRecipeComponent(
    public val componentArn: String,
    public val parameters: List<ImageRecipeComponentParameter>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ImageRecipeComponent): ImageRecipeComponent = ImageRecipeComponent(
            componentArn = javaType.componentArn(),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.ImageRecipeComponentParameter.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
