@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.imagebuilder.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property onFailure The action to take if the workflow fails. Must be one of `CONTINUE` or `ABORT`.
 * @property parallelGroup The parallel group in which to run a test Workflow.
 * @property parameters Configuration block for the workflow parameters. Detailed below.
 * @property workflowArn Amazon Resource Name (ARN) of the Image Builder Workflow.
 * The following arguments are optional:
 */
public data class ImageWorkflow(
    public val onFailure: String? = null,
    public val parallelGroup: String? = null,
    public val parameters: List<ImageWorkflowParameter>? = null,
    public val workflowArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.imagebuilder.outputs.ImageWorkflow): ImageWorkflow = ImageWorkflow(
            onFailure = javaType.onFailure().map({ args0 -> args0 }).orElse(null),
            parallelGroup = javaType.parallelGroup().map({ args0 -> args0 }).orElse(null),
            parameters = javaType.parameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.imagebuilder.kotlin.outputs.ImageWorkflowParameter.Companion.toKotlin(args0)
                })
            }),
            workflowArn = javaType.workflowArn(),
        )
    }
}
